/*
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: mem.c,v 4.34 1999/03/30 20:08:03 erik Rel $";
#endif
#include <stdio.h>
#ifdef EMULATE_ULA_DELAY
#include "z80.h"
#endif
#include "io.h"
#include "machine.h"
#include "util.h"
#if defined(XZX_PLUS3) && !defined(REGISTERED)
#include "fdc.h"
#endif
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef XZX_MGT
#include "mgt.h"
#endif
#include "screen.h"
#ifdef XZX_TRDOS
#include "trdos.h"
#endif
#include "mem.h"
int RealPageNumbers[8];
uns8 *TheMemory[8];
uns8 *RealMemory[NPAGES];
void
MemoryInit(void)
{
int i;
for (i = 0; i < NPAGES; i++)
{
RealMemory[i] = (uns8 *)Malloc(XZX_PAGESIZE, "MemoryInit");
}
}
int
LoadRomImage(char *image, int page, int num)
{
FILE *ifp;
size_t nread;
if (!(ifp = Fopen(image, "rb")))
{
Msg(M_PERR, "couldn't open ROM image <%s> for reading", image);
return -1;
}
while (num--)
{
nread = fread(RealMemory[page++], 1, XZX_PAGESIZE, ifp);
if (nread != XZX_PAGESIZE && nread != XZX_PAGESIZE / 2)
{
Msg(M_WARN, "ROM image <%s> is too short", image);
break;
}
}
(void)fclose(ifp);
return 0;
}
int
GetRomChecksum(int rom, int length)
{
int checksum = 0, tmp, i;
for (i = 0; i < length; i++)
{
tmp = checksum & 0x01;
checksum >>= 1;
if (tmp)
{
checksum |= 0x8000;
}
checksum ^= RealMemory[rom][i];
}
return checksum;
}
uns8
ReadOpcode48(uns16 addr)
{
uns8 op;
#ifdef XZX_IF1
CHECK_AND_PAGEIN_IF1(addr);
#endif
#ifdef XZX_TRDOS
CHECK_TRDOS(addr);
#endif
#ifdef XZX_MGT
CHECK_MGT(addr);
#endif
op = MEM(addr);
#ifdef EMULATE_ULA_DELAY
if ((addr & 0xc000) == 0x4000)
{
TSTATES += UlaDelay[TSTATES] & 0x7f;
}
#endif
#ifdef XZX_IF1
CHECK_AND_PAGEOUT_IF1(addr);
#endif
return op;
}
uns8
ReadOpcode128(uns16 addr)
{
uns8 op;
#ifdef XZX_IF1
CHECK_AND_PAGEIN_IF1(addr);
#endif
#ifdef XZX_TRDOS
CHECK_TRDOS(addr);
#endif
#ifdef XZX_MGT
CHECK_MGT(addr);
#endif
op = MEM(addr);
#ifdef EMULATE_ULA_DELAY
if (RPAGE(addr) >= RAM4 && RPAGE(addr) <= RAM7)
{
TSTATES += UlaDelay[TSTATES] & 0x7f;
}
#endif
#ifdef XZX_IF1
CHECK_AND_PAGEOUT_IF1(addr);
#endif
return op;
}
#ifdef XZX_PLUS3
uns8
ReadOpcode3(uns16 addr)
{
uns8 op;
#if defined(XZX_PLUS3) && !defined(REGISTERED)
CHECK_PLUS3_DOS(addr);
#endif
op = MEM(addr);
#ifdef EMULATE_ULA_DELAY
if (RPAGE(addr) >= RAM4 && RPAGE(addr) <= RAM7)
{
TSTATES += UlaDelay[TSTATES] & 0x7f;
}
#endif
return op;
}
#endif
uns8
ReadMem48(uns16 addr)
{
uns8 byte;
byte = MEM(addr);
#ifdef EMULATE_ULA_DELAY
if ((addr & 0xc000) == 0x4000)
{
TSTATES += UlaDelay[TSTATES] & 0x7f;
}
#endif
return byte;
}
uns8
ReadMem128(uns16 addr)
{
uns8 byte;
byte = MEM(addr);
#ifdef EMULATE_ULA_DELAY
if (RPAGE(addr) >= RAM4 && RPAGE(addr) <= RAM7)
{
TSTATES += UlaDelay[TSTATES] & 0x7f;
}
#endif
return byte;
}
#ifdef XZX_PLUS3
uns8
ReadMem3(uns16 addr)
{
uns8 byte;
byte = MEM(addr);
#ifdef EMULATE_ULA_DELAY
if (RPAGE(addr) >= RAM4 && RPAGE(addr) <= RAM7)
{
TSTATES += UlaDelay[TSTATES] & 0x7f;
}
#endif
return byte;
}
#endif
void
WriteMem48(uns16 addr, uns8 byte)
{
int page = VPAGE(addr);
if (RealPageNumbers[page] >= RAM0)
{
TheMemory[page][addr & 0x1fff] = byte;
if (RealPageNumbers[page] == ScreenSelect)
{
if ((addr &= 0x3fff) < (uns16)PIXEL_LENGTH)
{
ScreenWrite(addr, byte);
}
else if (addr < (uns16)(PIXEL_LENGTH + ATTR_LENGTH))
{
AttrWrite(addr, byte);
}
#ifdef EMULATE_ULA_DELAY
TSTATES += UlaDelay[TSTATES] & 0x7f;
#endif
}
}
}
void
WriteMem128(uns16 addr, uns8 byte)
{
int page = VPAGE(addr);
if (RealPageNumbers[page] >= RAM0)
{
TheMemory[page][addr & 0x1fff] = byte;
if (RealPageNumbers[page] == ScreenSelect)
{
if ((addr &= 0x3fff) < (uns16)PIXEL_LENGTH)
{
ScreenWrite(addr, byte);
}
else if (addr < (uns16)(PIXEL_LENGTH + ATTR_LENGTH))
{
AttrWrite(addr, byte);
}
}
#ifdef EMULATE_ULA_DELAY
if (RPAGE(addr) >= RAM4 && RPAGE(addr) <= RAM7)
{
TSTATES += UlaDelay[TSTATES] & 0x7f;
}
#endif
}
}
#ifdef XZX_PLUS3
void
WriteMem3(uns16 addr, uns8 byte)
{
int page = VPAGE(addr);



/* only this line is modified here - all after || is by Yarek */
/* the patch enables writing to ROM2 and ROM3 in ZX+3 (ZXVGS requires SRAM there) */
if (RealPageNumbers[page] >= RAM0 || RealPageNumbers[page] == SP3ROM2 || RealPageNumbers[page] == SP3ROM3)


{
TheMemory[page][addr & 0x1fff] = byte;
if (RealPageNumbers[page] == ScreenSelect)
{
if ((addr &= 0x3fff) < (uns16)PIXEL_LENGTH)
{
ScreenWrite(addr, byte);
}
else if (addr < (uns16)(PIXEL_LENGTH + ATTR_LENGTH))
{
AttrWrite(addr, byte);
}
}
#ifdef EMULATE_ULA_DELAY
if (RPAGE(addr) >= RAM4 && RPAGE(addr) <= RAM7)
{
TSTATES += UlaDelay[TSTATES] & 0x7f;
}
#endif
}
}
#endif
void
InitPages48(void)
{
Machine->pageIn(0, SP48ROM);
Machine->pageIn(1, RAM5);
Machine->pageIn(2, RAM2);
Machine->pageIn(3, RAM0);
}
void
InitPages128(void)
{
Machine->pageIn(0, SP128ROM0);
Machine->pageIn(1, RAM5);
Machine->pageIn(2, RAM2);
Machine->pageIn(3, RAM0);
}
#ifdef XZX_PLUS3
void
InitPages3(void)
{
Machine->pageIn(0, SP3ROM0);
Machine->pageIn(1, RAM5);
Machine->pageIn(2, RAM2);
Machine->pageIn(3, RAM0);
}
#endif
void
PageIn48(int frame, int rpage)
{
int i = frame << 1;
TheMemory[i] = RealMemory[rpage];
RealPageNumbers[i] = rpage;
i++;
TheMemory[i] = RealMemory[rpage] + XZX_PAGESIZE / 2;
switch (rpage)
{
#ifdef XZX_MF
case MF128ROM:
RealPageNumbers[i] = MFRAM;
break;
#endif
#ifdef XZX_MGT
case MGTROM:
RealPageNumbers[i] = MGTRAM;
break;
#endif
default:
RealPageNumbers[i] = rpage;
break;
}
}
void
PageIn128(int frame, int rpage)
{
int i = frame << 1;
TheMemory[i] = RealMemory[rpage];
RealPageNumbers[i] = rpage;
i++;
TheMemory[i] = RealMemory[rpage] + XZX_PAGESIZE / 2;
switch (rpage)
{
#ifdef XZX_MF
case MF128ROM:
RealPageNumbers[i] = MFRAM;
break;
#endif
#ifdef XZX_MGT
case MGTROM:
RealPageNumbers[i] = MGTRAM;
break;
#endif
default:
RealPageNumbers[i] = rpage;
break;
}
}
#ifdef XZX_PLUS3
void
PageIn3(int frame, int rpage)
{
int i = frame << 1;
TheMemory[i] = RealMemory[rpage];
RealPageNumbers[i] = rpage;
i++;
TheMemory[i] = RealMemory[rpage] + XZX_PAGESIZE / 2;
switch (rpage)
{
#ifdef XZX_MF
case MF3ROM:
RealPageNumbers[i] = MFRAM;
break;
#endif
default:
RealPageNumbers[i] = rpage;
break;
}
}
#endif
