/********************************************************************************
* Copyright (c) Erik Kunze 1998 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: keyboard.c,v 1.8 1999/03/30 20:08:03 erik Rel $";
#endif
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <stdio.h>
#include <string.h>
#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif
#include "debug.h"
#include "resource.h"
#include "io.h"
#include "util.h"
#include "emul.h"
#ifndef REGISTERED
#include "menu.h"
#include "monitor.h"
#endif
#include "keyboard.h"
#define ROW1			0
#define ROW2			1
#define ROW3			2
#define ROW4			3
#define ROW5			4
#define ROW6			5
#define ROW7			6
#define ROW8			7
#define NONE			8
#define COL1			1
#define COL2			2
#define COL3			4
#define COL4			8
#define COL5			16
enum KeyState { PRESSED, RELEASED, DELAYED };
#define DELAY_FRAMES	5
typedef struct _key {
enum KeyState state;
unsigned int frame;
uns8 row;
uns8 col;
} Key;
#define CAPS_SHIFT		96
#define SYMBOL_SHIFT	97
#define RETURN			98
#define VALID_KEY(key)	((key) >= 0x20 && (key) < 0x80)
#define PRESS(key) 		{ \
Key *kp = &keys[(key)];							\
kp->state = PRESSED;							\
kp->frame = Frame;								\
KeyPorts[kp->row] &= ~kp->col;					\
}
#define RELEASE(key) 	{ \
Key *kp = &keys[(key)];							\
if (kp->state == PRESSED)						\
{												\
int frames = Frame - kp->frame;				\
if (frames >= DELAY_FRAMES || frames < 0)	\
{											\
kp->state = RELEASED;					\
KeyPorts[kp->row] |= kp->col;			\
}											\
else										\
{											\
kp->state = DELAYED;					\
kp->frame = DELAY_FRAMES - frames;		\
}											\
}												\
}
#define NELEM(a)		(sizeof(a) / sizeof(a[0]))
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_X11) { x } }
#else
#define DEB(x)
#endif
uns8 KeyPorts[9];
static Key keys[128 - 32 + 3] = {
{ RELEASED, 0, ROW8, COL1 },
{ RELEASED, 0, ROW4, COL1 },
{ RELEASED, 0, ROW6, COL1 },
{ RELEASED, 0, ROW4, COL3 },
{ RELEASED, 0, ROW4, COL4 },
{ RELEASED, 0, ROW4, COL5 },
{ RELEASED, 0, ROW5, COL5 },
{ RELEASED, 0, ROW5, COL4 },
{ RELEASED, 0, ROW5, COL3 },
{ RELEASED, 0, ROW5, COL2 },
{ RELEASED, 0, ROW8, COL5 },
{ RELEASED, 0, ROW7, COL3 },
{ RELEASED, 0, ROW8, COL4 },
{ RELEASED, 0, ROW7, COL4 },
{ RELEASED, 0, ROW8, COL3 },
{ RELEASED, 0, ROW1, COL5 },
{ RELEASED, 0, ROW5, COL1 },
{ RELEASED, 0, ROW4, COL1 },
{ RELEASED, 0, ROW4, COL2 },
{ RELEASED, 0, ROW4, COL3 },
{ RELEASED, 0, ROW4, COL4 },
{ RELEASED, 0, ROW4, COL5 },
{ RELEASED, 0, ROW5, COL5 },
{ RELEASED, 0, ROW5, COL4 },
{ RELEASED, 0, ROW5, COL3 },
{ RELEASED, 0, ROW5, COL2 },
{ RELEASED, 0, ROW1, COL2 },
{ RELEASED, 0, ROW6, COL2 },
{ RELEASED, 0, ROW3, COL4 },
{ RELEASED, 0, ROW7, COL2 },
{ RELEASED, 0, ROW3, COL5 },
{ RELEASED, 0, ROW1, COL4 },
{ RELEASED, 0, ROW4, COL2 },
{ RELEASED, 0, ROW2, COL1 },
{ RELEASED, 0, ROW8, COL5 },
{ RELEASED, 0, ROW1, COL4 },
{ RELEASED, 0, ROW2, COL3 },
{ RELEASED, 0, ROW3, COL3 },
{ RELEASED, 0, ROW2, COL4 },
{ RELEASED, 0, ROW2, COL5 },
{ RELEASED, 0, ROW7, COL5 },
{ RELEASED, 0, ROW6, COL3 },
{ RELEASED, 0, ROW7, COL4 },
{ RELEASED, 0, ROW7, COL3 },
{ RELEASED, 0, ROW7, COL2 },
{ RELEASED, 0, ROW8, COL3 },
{ RELEASED, 0, ROW8, COL4 },
{ RELEASED, 0, ROW6, COL2 },
{ RELEASED, 0, ROW6, COL1 },
{ RELEASED, 0, ROW3, COL1 },
{ RELEASED, 0, ROW3, COL4 },
{ RELEASED, 0, ROW2, COL2 },
{ RELEASED, 0, ROW3, COL5 },
{ RELEASED, 0, ROW6, COL4 },
{ RELEASED, 0, ROW1, COL5 },
{ RELEASED, 0, ROW3, COL2 },
{ RELEASED, 0, ROW1, COL1 },
{ RELEASED, 0, ROW6, COL1 },
{ RELEASED, 0, ROW1, COL2 },
{ RELEASED, 0, NONE, NONE },
{ RELEASED, 0, NONE, NONE },
{ RELEASED, 0, NONE, NONE },
{ RELEASED, 0, ROW7, COL5 },
{ RELEASED, 0, ROW5, COL1 },
{ RELEASED, 0, ROW1, COL3 },
{ RELEASED, 0, ROW2, COL1 },
{ RELEASED, 0, ROW8, COL5 },
{ RELEASED, 0, ROW1, COL4 },
{ RELEASED, 0, ROW2, COL3 },
{ RELEASED, 0, ROW3, COL3 },
{ RELEASED, 0, ROW2, COL4 },
{ RELEASED, 0, ROW2, COL5 },
{ RELEASED, 0, ROW7, COL5 },
{ RELEASED, 0, ROW6, COL3 },
{ RELEASED, 0, ROW7, COL4 },
{ RELEASED, 0, ROW7, COL3 },
{ RELEASED, 0, ROW7, COL2 },
{ RELEASED, 0, ROW8, COL3 },
{ RELEASED, 0, ROW8, COL4 },
{ RELEASED, 0, ROW6, COL2 },
{ RELEASED, 0, ROW6, COL1 },
{ RELEASED, 0, ROW3, COL1 },
{ RELEASED, 0, ROW3, COL4 },
{ RELEASED, 0, ROW2, COL2 },
{ RELEASED, 0, ROW3, COL5 },
{ RELEASED, 0, ROW6, COL4 },
{ RELEASED, 0, ROW1, COL5 },
{ RELEASED, 0, ROW3, COL2 },
{ RELEASED, 0, ROW1, COL3 },
{ RELEASED, 0, ROW6, COL5 },
{ RELEASED, 0, ROW1, COL2 },
{ RELEASED, 0, NONE, NONE },
{ RELEASED, 0, NONE, NONE },
{ RELEASED, 0, NONE, NONE },
{ RELEASED, 0, NONE, NONE },
{ RELEASED, 0, NONE, NONE },
{ RELEASED, 0, ROW1, COL1 },
{ RELEASED, 0, ROW8, COL2 },
{ RELEASED, 0, ROW7, COL1 }
};
static int unshiftCursor, emulatedShift, trueShift;
void
KbdReset(void)
{
Key *kp;
(void)memset(KeyPorts, 0xff, sizeof(KeyPorts));
for (kp = keys; kp < &keys[NELEM(keys)]; kp++)
{
kp->state = RELEASED;
}
unshiftCursor = 0;
emulatedShift = 0;
trueShift = 0;
}
void
KbdRefresh(void)
{
Key *kp;
for (kp = keys; kp < &keys[NELEM(keys)]; kp++)
{
if (kp->state == DELAYED && !--kp->frame)
{
kp->state = RELEASED;
KeyPorts[kp->row] |= kp->col;
}
}
}
void
#ifdef REGISTERED
KbdKeypress(Widget w, XtPointer client, XEvent *xev, Boolean *cont)
#else
KbdKeypress(XEvent *xev)
#endif
{
KeySym ks, ks0;
(void)XLookupString((XKeyEvent *)xev, NULL, 0, &ks, NULL);
ks0 = XLookupKeysym((XKeyEvent *)xev, 0);
DEB(Msg(M_DEBUG, "ks = %04x (%s), ks0 = %04x (%s)",
ks, XKeysymToString(ks), ks0, XKeysymToString(ks0)););
if (ks0 == GETCFG(joyUp))
{
InPorts[P_KEMPSTON] |= B_UP;
}
else if (ks0 == GETCFG(joyDown))
{
InPorts[P_KEMPSTON] |= B_DOWN;
}
else if (ks0 == GETCFG(joyLeft))
{
InPorts[P_KEMPSTON] |= B_LEFT;
}
else if (ks0 == GETCFG(joyRight))
{
InPorts[P_KEMPSTON] |= B_RIGHT;
}
else if (ks0 == GETCFG(joyFire))
{
InPorts[P_KEMPSTON] |= B_FIRE;
}
switch ((int)ks)
{
#ifndef REGISTERED
case XK_F1:
MainMenu(OSD_HELP);
break;
case XK_F2:
WriteSnapshotWithFS();
break;
case XK_F3:
ReadSnapshotWithFS();
break;
case XK_F4:
WriteScreenDumpWithFS();
break;
case XK_F5:
MainMenu(OSD_RESET);
break;
case XK_F6:
MainMenu(OSD_NMI);
break;
case XK_F7:
Debugger(DBG_FKEY);
break;
case XK_F8:
break;
case XK_F9:
HardwareMenu();
break;
case XK_F10:
case XK_F12:
MainMenu(OSD_QUIT);
break;
#endif
case XK_Tab:
unshiftCursor = !unshiftCursor;
break;
case XK_backslash:
case XK_bar:
KbdReset();
break;
case XK_Return:
PRESS(RETURN);
break;
case XK_Control_L:
PRESS(CAPS_SHIFT);
PRESS(SYMBOL_SHIFT);
emulatedShift++;
break;
case XK_Shift_L:
PRESS(CAPS_SHIFT);
emulatedShift++;
break;
case XK_Alt_L:
case XK_Meta_L:
PRESS(SYMBOL_SHIFT);
emulatedShift++;
break;
case XK_BackSpace:
case XK_Delete:
PRESS(CAPS_SHIFT);
PRESS('0' - 0x20);
break;
case XK_Escape:
PRESS(CAPS_SHIFT);
PRESS('1' - 0x20);
break;
case XK_Up:
if (!unshiftCursor)
{
PRESS(CAPS_SHIFT);
}
PRESS('7' - 0x20);
break;
case XK_Down:
if (!unshiftCursor)
{
PRESS(CAPS_SHIFT);
}
PRESS('6' - 0x20);
break;
case XK_Left:
if (!unshiftCursor)
{
PRESS(CAPS_SHIFT);
}
PRESS('5' - 0x20);
break;
case XK_Right:
if (!unshiftCursor)
{
PRESS(CAPS_SHIFT);
}
PRESS('8' - 0x20);
break;
case XK_sterling:
if (!emulatedShift)
{
PRESS(SYMBOL_SHIFT);
PRESS('`' - 0x20);
break;
}
default:
if (emulatedShift)
{
if (VALID_KEY(ks0))
{
PRESS(ks0 - 0x20);
}
}
else if (VALID_KEY(ks))
{
if	(ks >= 'A' && ks <= 'Z')
{
PRESS(CAPS_SHIFT);
}
else if (!((ks >= 'a' && ks <= 'z')
|| (ks >= '0' && ks <= '9')
|| ks == ' '))
{
PRESS(SYMBOL_SHIFT);
}
PRESS(ks - 0x20);
}
break;
}
}
void
#ifdef REGISTERED
KbdKeyrelease(Widget w, XtPointer client, XEvent *xev, Boolean *cont)
#else
KbdKeyrelease(XEvent *xev)
#endif
{
KeySym ks, ks0;
(void)XLookupString((XKeyEvent *)xev, NULL, 0, &ks, NULL);
ks0 = XLookupKeysym((XKeyEvent *)xev, 0);
DEB(Msg(M_DEBUG, "ks = %04x (%s), ks0 = %04x (%s)",
ks, XKeysymToString(ks), ks0, XKeysymToString(ks0)););
if (ks0 == GETCFG(joyUp))
{
InPorts[P_KEMPSTON] &= ~B_UP;
}
else if (ks0 == GETCFG(joyDown))
{
InPorts[P_KEMPSTON] &= ~B_DOWN;
}
else if (ks0 == GETCFG(joyLeft))
{
InPorts[P_KEMPSTON] &= ~B_LEFT;
}
else if (ks0 == GETCFG(joyRight))
{
InPorts[P_KEMPSTON] &= ~B_RIGHT;
}
else if (ks0 == GETCFG(joyFire))
{
InPorts[P_KEMPSTON] &= ~B_FIRE;
}
switch ((int)ks)
{
case XK_Control_R:
case XK_Shift_R:
case XK_Alt_R:
case XK_Meta_R:
case XK_Mode_switch:
trueShift = xev->xkey.state == 1 ? 1 : 2;
break;
case XK_Return:
RELEASE(RETURN);
break;
case XK_Control_L:
RELEASE(CAPS_SHIFT);
RELEASE(SYMBOL_SHIFT);
if (emulatedShift)
{
emulatedShift--;
}
break;
case XK_Shift_L:
RELEASE(CAPS_SHIFT);
if (emulatedShift)
{
emulatedShift--;
}
break;
case XK_Alt_L:
case XK_Meta_L:
RELEASE(SYMBOL_SHIFT);
if (emulatedShift)
{
emulatedShift--;
}
break;
case XK_BackSpace:
case XK_Delete:
RELEASE(CAPS_SHIFT);
RELEASE('0' - 0x20);
break;
case XK_Escape:
RELEASE(CAPS_SHIFT);
RELEASE('1' - 0x20);
break;
case XK_Up:
if (!unshiftCursor)
{
RELEASE(CAPS_SHIFT);
}
RELEASE('7' - 0x20);
break;
case XK_Down:
if (!unshiftCursor)
{
RELEASE(CAPS_SHIFT);
}
RELEASE('6' - 0x20);
break;
case XK_Left:
if (!unshiftCursor)
{
RELEASE(CAPS_SHIFT);
}
RELEASE('5' - 0x20);
break;
case XK_Right:
if (!unshiftCursor)
{
RELEASE(CAPS_SHIFT);
}
RELEASE('8' - 0x20);
break;
case XK_sterling:
if (!emulatedShift)
{
RELEASE(SYMBOL_SHIFT);
RELEASE('`' - 0x20);
break;
}
default:
if (emulatedShift)
{
if (VALID_KEY(ks0))
{
RELEASE(ks0 - 0x20);
}
}
else if (VALID_KEY(ks))
{
if (keys[ks - 0x20].state != PRESSED)
{
ks = XLookupKeysym((XKeyEvent *)xev, trueShift);
if (!VALID_KEY(ks) || keys[ks - 0x20].state != PRESSED)
{
DEB(Msg(M_DEBUG, "ks = %04x -not fixed-", ks););
break;
}
DEB(Msg(M_DEBUG, "ks = %04x (%s) -fixed-",
ks, XKeysymToString(ks)););
}
if	(ks >= 'A' && ks <= 'Z')
{
RELEASE(CAPS_SHIFT);
}
else if (!((ks >= 'a' && ks <= 'z')
|| (ks >= '0' && ks <= '9')
|| ks == ' '))
{
RELEASE(SYMBOL_SHIFT);
}
RELEASE(ks - 0x20);
}
break;
}
}
