/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef JOY
#ifndef lint
static char rcsid[] = "$Id: joystick.c,v 4.7 1999/01/12 21:02:17 erik Rel $";
#endif
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include JOYSTICK_H_PATH
#include <assert.h>
#include "debug.h"
#include "resource.h"
#include "io.h"
#include "util.h"
#include "emul.h"
#include "joystick.h"
#if defined(JS_VERSION) && JS_VERSION > 0x010000
#define NEW_INTERFACE
#endif
#ifdef __FreeBSD__
#define JS_DATA_TYPE	joystick
#define JS_RETURN		sizeof(struct JS_DATA_TYPE)
#endif
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_JOY) { x } }
#else
#define DEB(x)
#endif
static int joyFd;
#ifndef NEW_INTERFACE
static int centreX, centreY;
#endif
#ifdef NEW_INTERFACE
void
JoyInit(void)
{
unsigned int version;
char name[256];
char axes = 2, buttons = 2;
if ((joyFd = open(GETCFG(joyDevice), O_RDONLY | O_NONBLOCK)) < 1)
{
Msg(M_PERR, "couldn't open joystick device for reading");
SETCFG(joyActive, -1);
return;
}
(void)ioctl(joyFd, JSIOCGVERSION, &version);
assert(version > 0x010000);
(void)ioctl(joyFd, JSIOCGAXES, &axes);
(void)ioctl(joyFd, JSIOCGBUTTONS, &buttons);
(void)ioctl(joyFd, JSIOCGNAME(sizeof(name)), name);
DEB(Msg(M_DEBUG, "JOY: driver version %d.%d.%d",
version >> 16, (version >> 8) & 0xff, version & 0xff);
Msg(M_DEBUG, "JOY: %s, %d axes, %d buttons",
name, (int)axes, (int)buttons););
if (buttons < 3)
{
SETCFG(joyJuggle, -1);
}
if (buttons < 2)
{
SETCFG(joyAutofire, -1);
}
}
#else
void
JoyInit(void)
{
struct JS_DATA_TYPE jdata;
int active = GETCFG(joyActive);
if ((joyFd = open(GETCFG(joyDevice), O_RDONLY)) < 1)
{
Msg(M_PERR, "couldn't open joystick device for reading");
active = -1;
}
else
{
DEB(Msg(M_DEBUG, "JOY: driver version 0.8.X");
Msg(M_DEBUG, "JOY: unknown joystick type"););
if (read(joyFd, &jdata, JS_RETURN) != JS_RETURN)
{
Msg(M_PERR, "couldn't read current joystick settings");
active = -1;
}
else
{
centreX = jdata.x;
centreY = jdata.y;
}
SETCFG(joyJuggle, -1);
}
SETCFG(joyActive, active);
}
#endif
#ifdef NEW_INTERFACE
int
JoyRead(void)
{
static int res = 0, autofire = 0, juggle = 0;
static unsigned int afframe = 0;
static int juggleval = B_LEFT;
static unsigned int juggleframe = 0;
struct js_event jev;
if (read(joyFd, &jev, sizeof(jev)) == sizeof(jev))
{
if ((jev.type & ~JS_EVENT_INIT) == JS_EVENT_BUTTON)
{
switch (jev.number)
{
case 0:
if (jev.value)
{
res |= B_FIRE;
}
else
{
res &= ~B_FIRE;
}
break;
case 1:
if (jev.value)
{
autofire = res & B_FIRE ? 0 : 1;
}
else
{
autofire = 0;
res &= ~B_FIRE;
}
break;
case 2:
if (jev.value)
{
juggle = res & (B_LEFT | B_RIGHT) ? 0 : 1;
}
else
{
juggle = 0;
res &= ~(B_LEFT | B_RIGHT);
}
break;
case 4:
if (jev.value)
{
if (autofire)
{
if (GETCFG(joyAutofire) > 1)
{
SETCFG(joyAutofire, GETCFG(joyAutofire) - 1);
}
}
else if (juggle)
{
if (GETCFG(joyJuggle) > 1)
{
SETCFG(joyJuggle, GETCFG(joyJuggle) - 1);
}
}
else if (!GETCFG(fast) && GETCFG(speed))
{
int speed = GETCFG(speed);
if (speed > 10)
{
speed -= 10;
SETCFG(speed, speed);
EmuSetSpeed(speed);
}
}
}
break;
case 5:
if (jev.value)
{
if (autofire)
{
if (GETCFG(joyAutofire) < 50)
{
SETCFG(joyAutofire, GETCFG(joyAutofire) + 1);
}
}
else if (juggle)
{
if (GETCFG(joyJuggle) < 50)
{
SETCFG(joyJuggle, GETCFG(joyJuggle) + 1);
}
}
else if (!GETCFG(fast) && GETCFG(speed))
{
int speed = GETCFG(speed);
if (speed < 200)
{
speed += 10;
SETCFG(speed, speed);
EmuSetSpeed(speed);
}
}
}
break;
}
}
else
{
switch ((int)jev.number)
{
case 0:
if (jev.value <= -GETCFG(joyTolerance))
{
res |= B_LEFT;
}
else if (jev.value >= GETCFG(joyTolerance))
{
res |= B_RIGHT;
}
else
{
res &= ~(B_LEFT | B_RIGHT);
}
break;
case 1:
if (jev.value <= -GETCFG(joyTolerance))
{
res |= B_UP;
}
else if (jev.value >= GETCFG(joyTolerance))
{
res |= B_DOWN;
}
else
{
res &= ~(B_UP | B_DOWN);
}
break;
}
}
}
if (autofire)
{
if (50 - (Frame - afframe) > GETCFG(joyAutofire))
{
afframe = Frame;
res ^= B_FIRE;
}
}
if (juggle)
{
if (50 - (Frame - juggleframe) > GETCFG(joyJuggle))
{
juggleframe = Frame;
if (res & (B_LEFT | B_RIGHT))
{
res &= ~(B_LEFT | B_RIGHT);
}
else
{
res |= juggleval;
juggleval ^= (B_LEFT | B_RIGHT);
}
}
}
return res;
}
#else
int
JoyRead(void)
{
static int afval = 0;
static unsigned int afframe = 0;
struct JS_DATA_TYPE jdata;
int res = 0;
if (read(joyFd, &jdata, JS_RETURN) != JS_RETURN)
{
Msg(M_PWARN, "lost joystick connection");
}
else
{
if (jdata.x <= centreX - GETCFG(joyTolerance))
{
res |= B_LEFT;
}
else if (jdata.x >= centreX + GETCFG(joyTolerance))
{
res |= B_RIGHT;
}
if (jdata.y <= centreY - GETCFG(joyTolerance))
{
res |= B_UP;
}
else if (jdata.y >= centreY + GETCFG(joyTolerance))
{
res |= B_DOWN;
}
#ifdef __FreeBSD__
if (jdata.b1)
#else
if (jdata.buttons & 0x01)
#endif
{
res |= B_FIRE;
}
#ifdef __FreeBSD__
else if (jdata.b2)
#else
else if (jdata.buttons & 0x02)
#endif
{
if (50 - (Frame - afframe) > GETCFG(joyAutofire))
{
afframe = Frame;
afval ^= B_FIRE;
res |= afval;
}
}
}
return res;
}
#endif
#endif
