/********************************************************************************
* Copyright (c) Razvan Surdulescu 1996
*               Erik Kunze        1996 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Razvan Surdulescu
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: dialog.c,v 4.25 1999/04/03 15:01:37 erik Rel $";
#endif
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include "resource.h"
#include "mem.h"
#include "io.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "keyboard.h"
#ifdef XZX_KMOUSE
#include "kmouse.h"
#endif
#include "main.h"
#include "screen.h"
#include "tables.h"
#include "dialog.h"
#define PAGE_SIZE		14U
#define MAXFILELEN		256
#define DIR_TYPE		0
#define FILE_TYPE		1
typedef struct _mydirent {
int type;
char * name;
} mydirent;
#define GET_ATTR(x)		RealMemory[OSD][(x)]
#define SET_ATTR(x,y)	RealMemory[OSD][(x)] = (y); AttrWrite((x), (y));
#define SET_PIXEL(x,y)	RealMemory[OSD][(x)] = (y); ScreenWrite((x), (y));
#define NELEM(a)		(sizeof(a) / sizeof(a[0]))
static uns16 xyToAddr (uns8, uns8);
static uns16 xyToAttr (uns8, uns8);
static int direntsCompare(void *, void *);
static void direntDestroy(void *);
static int readDirectory(int *);
static mydirent *getFileOrDir(unsigned int);
static void displayFiles(unsigned int);
static char *addExtension(const char *, const char *);
static void displayMenuTitle(const char *);
int InDialog = 0;
KeySym KeyDialog;
static const char *menuBottom[] = {
"   UP/DOWN arrows move cursor   ",
"   ENT/KEY select               ",
"   ESC     return               ",
NULL
};
static uns8 cursorX = 0;
static uns8 cursorY = 0;
static uns8 screenAttr = MENU_TEXT_ATTR;
static char *saveDir;
static char *saveFSelDir;
static unsigned int numFiles = 0;
static unsigned int numDirectories = 0;
static Llist *dirDirectoriesList = NULL;
static Llist *dirFilesList = NULL;
void
DialogInit(int copyright)
{
time_t timeStart;
if (!(saveDir = getcwd(NULL, MAXPATHLEN)))
{
Msg(M_FATAL, "getcwd failed");
}
saveFSelDir = (char*)Malloc(MAXPATHLEN, "DialogInit");
(void)strcpy(saveFSelDir, saveDir);
(void)EnterOSD();
ClearScreen();
SetBorderColor((MENU_TEXT_ATTR & PAPER) >> 3);
SetCursor((COLS - strlen(Version)) / 2, 3);
PrintString(Version);
SetCursor(1, 5);
PrintString("ZX Spectrum 48/128/+3 emulator");
SetCursor(3, 7);
PrintString("Pentagon/Scorpion emulator");
SetAttr((WHITE << 3) | RED);
SetCursor(11, 9);
PrintString("Shareware");
SetAttr(MENU_TEXT_ATTR);
SetCursor(1, 13);
PrintString(" \177 Des Herriott       1993-94");
SetCursor(1, 15);
PrintString("   Erik Kunze         1995-99");
SetCursor(1, 17);
PrintString("   Razvan Surdulescu  1996   ");
timeStart = time(NULL);
while ((time(NULL) - timeStart) < 5)
{
ScreenRefresh();
ProcessEvents();
}
LeaveOSD(0);
}
static uns16
xyToAddr (uns8 x, uns8 y)
{
assert(x < COLS &&  y < ROWS);
y *= 8;
return ((y / 64) * (PIXEL_LENGTH / 3) +
((y % 64) / 8) * COLS +
(y % 8) * X_PIXELS +
x);
}
static uns16
xyToAttr (uns8 x, uns8 y)
{
assert(x < COLS && y < ROWS);
return (ATTR_OFFSET + y * COLS + x);
}
void
SetAttr (uns8 attr)
{
screenAttr = attr;
}
uns8
GetAttr(void)
{
return screenAttr;
}
void
SetCursor (uns8 x, uns8 y)
{
cursorX = x < COLS ? x : COLS - 1;
cursorY = y < ROWS ? y : ROWS - 1;
}
void
GetCursor(uns8 *x, uns8 *y)
{
*x = cursorX;
*y = cursorY;
}
void
ClearScreen(void)
{
cursorX = 0;
cursorY = 0;
DrawBox(COLS, ROWS);
}
void
DrawBox(uns8 width, uns8 height)
{
uns8 saveX = cursorX, saveY = cursorY;
uns8 i;
for (; height != 0; height--, cursorY++)
{
for (cursorX = saveX, i = width; i != 0; i--)
{
PrintLetter(' ');
}
}
cursorX = saveX;
cursorY = saveY;
}
void
PrintLetter(uns8 letter)
{
if (cursorX < COLS && cursorY < ROWS)
{
uns8 i;
uns16 mem;
uns8 *chr;
if (letter < ' ' || letter > ' ' + NELEM(CharSet))
{
letter = '?';
}
chr = (uns8 *)CharSet[letter - ' '];
mem = xyToAttr(cursorX, cursorY);
SET_ATTR(mem, screenAttr);
mem = xyToAddr(cursorX, cursorY);
for (i = 0; i < 8; i++, mem += X_PIXELS, chr++)
{
SET_PIXEL(mem, *chr);
}
cursorX++;
}
}
void
PrintString(const char *string)
{
while (*string && cursorX < COLS)
{
PrintLetter(*string++);
}
}
KeySym
GetKey(void)
{
int oldInDialog = InDialog;
XEvent xev;
InDialog = 1;
for (KeyDialog = 0; !KeyDialog;)
{
XPeekEvent(Dpy, &xev);
ProcessEvents();
}
InDialog = oldInDialog;
return KeyDialog;
}
int
GetString(char *string, int len, int width)
{
int finish = 0;
int pos;
uns8 begX = cursorX;
uns8 begY = cursorY;
PrintLetter('_');
for (pos = width; pos > 1; pos--)
{
PrintLetter(' ');
}
pos = 0;
SetCursor(begX, begY);
ScreenRefresh();
for (;;)
{
switch ((int)GetKey())
{
case XK_Return:
finish = 1;
goto quit;
case ESCAPE:
case XK_Tab:
finish = 2;
goto quit;
case XK_BackSpace:
if (pos > 0)
{
string[--pos] = '\0';
if (pos < width - 1)
{
PrintLetter(' ');
cursorX -= 2;
}
else
{
SetCursor(begX, begY);
PrintString(string + (pos - width) + 1);
}
}
break;
default:
if (KeyDialog >= 0x20 && KeyDialog <= 0x7e && pos + 1 < len)
{
string[pos++] = (char)KeyDialog;
string[pos] = '\0';
if (pos < width)
{
PrintLetter((uns8)KeyDialog);
}
else
{
SetCursor(begX, begY);
PrintString(string + (pos - width) + 1);
}
}
break;
}
PrintLetter('_');
cursorX--;
ScreenRefresh();
}
quit:
PrintLetter(' ');
string[pos] = '\0';
return (finish != 2);
}
int
ConfirmBox(const char *string)
{
int oldInDialog;
KeySym key;
oldInDialog = EnterOSD();
ClearScreen();
SetCursor((COLS - strlen(string)) / 2, ROWS / 2 - 1);
PrintString(string);
ScreenRefresh();
key = GetKey();
LeaveOSD(oldInDialog);
return (key == XK_y || key == XK_Y);
}
int
EnterOSD(void)
{
static unsigned int nag = 0;
int oldInDialog = InDialog;
time_t timeStart;
if (!oldInDialog)
{
(void)XAutoRepeatOn(Dpy);
KbdReset();
SetBorderColor((MENU_TEXT_ATTR & PAPER) >> 3);
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
AudioControl(AUC_OFF);
#endif
#ifdef XZX_KMOUSE
if (GETCFG(kmouseActive))
{
KmouseOff();
}
#endif
}
InDialog = 1;
if (!(++nag % 10))
{
ClearScreen();
SetBorderColor((MENU_TEXT_ATTR & PAPER) >> 3);
SetCursor(1, 7);
PrintString("This program is ");
SetAttr((WHITE << 3) | RED);
PrintString("Shareware");
SetAttr(MENU_TEXT_ATTR);
PrintString(". It");
SetCursor(1, 9);
PrintString("is not completely functional,");
SetCursor(1, 11);
PrintString("and the parts which are left");
SetCursor(1, 13);
PrintString("out are included when you");
SetCursor(1, 15);
PrintString("register. See file README for");
SetCursor(1, 17);
PrintString("details.");
timeStart = time(NULL);
while ((time(NULL) - timeStart) < 5)
{
ScreenRefresh();
ProcessEvents();
}
(void)GetKey();
}
return oldInDialog;
}
void
LeaveOSD(int oldInDialog)
{
if (!oldInDialog)
{
(void)XAutoRepeatOff(Dpy);
SetBorderColor(LastBorderColor & B_BORDER);
ForceScreenRefresh();
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
AudioControl(AUC_ON);
#endif
#ifdef XZX_KMOUSE
if (GETCFG(kmouseActive))
{
KmouseOn();
}
#endif
}
InDialog = oldInDialog;
}
static int
direntsCompare(void *d1, void *d2)
{
return (strcmp(((mydirent *)d1)->name, ((mydirent *)d2)->name));
}
static void
direntDestroy(void *d)
{
assert(((mydirent *)d)->name != NULL);
free(((mydirent *)d)->name);
}
static int
readDirectory(int *fileTypes)
{
DIR *dir;
struct dirent *ent;
struct stat buf;
char *currentPath, *p;
mydirent *myDirent;
int *type;
if (!(currentPath = getcwd(NULL, MAXPATHLEN))
|| !(dir = opendir(currentPath)))
{
Msg(M_PERR, "couldn't open directory <%s>", currentPath);
free(currentPath);
return -1;
}
while ((ent = readdir(dir)))
{
if (ent->d_name[0] == '.' && ent->d_name[1] != '.')
{
continue;
}
(void)stat(ent->d_name, &buf);
if (S_ISDIR(buf.st_mode))
{
myDirent = Malloc(sizeof(mydirent), "readDirectory");
myDirent->type = DIR_TYPE;
myDirent->name = Strdup(ent->d_name, "readDirectory");
dirDirectoriesList = SortedInsertList((void *)myDirent,
direntsCompare,
dirDirectoriesList);
numDirectories++;
}
else if (S_ISREG(buf.st_mode))
{
p = strrchr(ent->d_name, '.');
for (type = fileTypes; *type != FT_END; type++)
{
if (*type == FT_ANY
|| (p && (!strcasecmp(p + 1, FtExt[*type]))))
{
myDirent = Malloc(sizeof(mydirent), "readDirectory");
myDirent->type = FILE_TYPE;
myDirent->name = Strdup(ent->d_name, "readDirectory");
dirFilesList = SortedInsertList((void *)myDirent,
direntsCompare,
dirFilesList);
numFiles++;
}
}
}
}
(void)closedir(dir);
free(currentPath);
return 0;
}
static mydirent *
getFileOrDir(unsigned int which)
{
if (which < numDirectories)
{
return ((mydirent*) RetrieveElemList(dirDirectoriesList, which));
}
which -= numDirectories;
if (which < numFiles)
{
return ((mydirent*) RetrieveElemList(dirFilesList, which));
}
return NULL;
}
static void
displayFiles(unsigned int page)
{
unsigned int cnt, len;
char *name;
mydirent *disp;
uns8 attr= GetAttr();
SetAttr(MENU_SELECT_ATTR);
SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y);
DrawBox(COLS - 2 * (MENU_CURSOR_X + 1), PAGE_SIZE);
for (cnt = page * PAGE_SIZE; cnt < (page + 1) * PAGE_SIZE; cnt++)
{
if (!(disp = getFileOrDir(cnt)))
{
break;
}
name  = disp->name;
for (len = COLS - 2 * (MENU_CURSOR_X + 1); len > 0 && *name; len--)
{
PrintLetter(*name++);
}
if (disp->type == DIR_TYPE && len)
{
PrintLetter('/');
}
SetCursor(MENU_CURSOR_X + 1, cursorY + 1);
}
SetAttr(attr);
}
static char *
addExtension(const char *string, const char *ext)
{
char *p;
if (!(p = strrchr(string, '.')))
{
p = (char*)Malloc(strlen(string) + strlen(ext) + 2, "addExtension");
(void)strcpy(p, string);
(void)strcat(p, ".");
(void)strcat(p, ext);
}
else
{
p = Strdup(string, "addExtension");
}
return p;
}
char *
FileSelector(const char *header, int valid, int *types)
{
static unsigned int item = 0;
int oldInDialog;
mydirent *file;
struct stat buf;
char name[MAXFILELEN];
char *returnName = NULL;
char *returnTotal = NULL;
oldInDialog = EnterOSD();
(void)chdir(saveFSelDir);
{
const char *selectorText[PAGE_SIZE + 2];
int i;
selectorText[0] = header;
for (i = 1; i <= NOPTS(selectorText); i++)
{
selectorText[i] = " ";
}
selectorText[i] = NULL;
DisplayMenu(selectorText);
}
SetCursor(0, ROWS - NOPTS(menuBottom) - 2);
PrintString("   TAB     switch fields        ");
ScreenRefresh();
if (readDirectory(types) == -1)
{
goto quit;
}
if (item >= numFiles + numDirectories)
{
item = numFiles + numDirectories - 1;
}
displayFiles(item / PAGE_SIZE);
SetCursor(0, PAGE_SIZE + 3);
PrintString(" File [                       ] ");
for (;;)
{
switch ((int)BrowseList(&item, numFiles + numDirectories, PAGE_SIZE,
displayFiles))
{
case XK_Tab:
{
int ret;
SetAttr(MENU_SELECT_ATTR);
SetCursor(7, PAGE_SIZE + 3);
ret = GetString(name, MAXFILELEN, 23);
SetAttr(MENU_TEXT_ATTR);
SetCursor(0, PAGE_SIZE + 3);
PrintString(" File [                       ] ");
if (ret)
{
if (stat(name, &buf) != -1)
{
if (S_ISDIR(buf.st_mode))
{
(void)chdir(name);
goto chdir;
}
else if (S_ISREG(buf.st_mode))
{
if (valid
|| ConfirmBox("Overwrite file ? [y/n]"))
{
returnName = addExtension(name,
FtExt[*types]);
}
goto quit;
}
}
else if (errno == ENOENT && !valid)
{
returnName = addExtension(name, FtExt[*types]);
goto quit;
}
}
}
break;
case XK_Return:
file = getFileOrDir(item);
assert(file != NULL);
if (file->type == DIR_TYPE)
{
(void)chdir(file->name);
chdir:
DestroyList(dirFilesList, direntDestroy);
numFiles = 0;
dirFilesList = NULL;
DestroyList(dirDirectoriesList, direntDestroy);
numDirectories = 0;
dirDirectoriesList = NULL;
if (readDirectory(types) == -1)
{
goto quit;
}
displayFiles(0);
item = 0;
}
else
{
assert(file->type == FILE_TYPE);
if (valid || ConfirmBox("Overwrite file ? [y/n]"))
{
returnName = Strdup(file->name, "FileSelector");
}
goto quit;
}
break;
case ESCAPE:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
DestroyList(dirFilesList, direntDestroy);
numFiles = 0;
dirFilesList = NULL;
DestroyList(dirDirectoriesList, direntDestroy);
numDirectories = 0;
dirDirectoriesList = NULL;
if (!getcwd(saveFSelDir, MAXPATHLEN))
{
Msg(M_FATAL, "getcwd failed");
}
if (returnName)
{
if (*returnName == '/'
|| !strncmp(returnName, "./", 2)
|| !strncmp(returnName, "../", 3))
{
returnTotal = Strdup(returnName, "FileSelector");
}
else
{
returnTotal = (char*)Malloc(strlen(saveFSelDir) +
strlen(returnName) + 2, "FileSelector");
(void)strcpy(returnTotal, saveFSelDir);
(void)strcat(returnTotal, "/");
(void)strcat(returnTotal, returnName);
}
free(returnName);
}
(void)chdir(saveDir);
return returnTotal;
}
static void
displayMenuTitle(const char *title)
{
uns8 attr= GetAttr();
SetAttr(BRIGHT | (BLACK << 3) | WHITE);
PrintLetter(' ');
PrintString(title);
while (cursorX < COLS)
{
PrintLetter(' ');
}
if (!GETCFG(mono))
{
SetCursor(COLS - 6, cursorY);
SetAttr(BRIGHT | (BLACK << 3) | RED);
PrintLetter('\200');
SetAttr(BRIGHT | (RED << 3) | YELLOW);
PrintLetter('\200');
SetAttr(BRIGHT | (YELLOW << 3) | GREEN);
PrintLetter('\200');
SetAttr(BRIGHT | (GREEN << 3) | CYAN);
PrintLetter('\200');
SetAttr(BRIGHT | (CYAN << 3) | BLACK);
PrintLetter('\200');
}
SetAttr(attr);
}
void
DisplayMenu(const char **menu)
{
int i;
const char **s;
SetAttr(MENU_TEXT_ATTR);
ClearScreen();
displayMenuTitle(*menu++);
SetAttr(MENU_SELECT_ATTR);
while (*menu)
{
SetCursor(0, cursorY + 1);
PrintLetter('\201');
if (*menu[0] == '`')
{
SetAttr(MENU_DISABLED_ATTR);
PrintString(&menu[0][1]);
SetAttr(MENU_SELECT_ATTR);
}
else
{
PrintString(menu[0]);
}
while (cursorX < COLS - 1)
{
PrintLetter(' ');
}
PrintLetter('\205');
menu++;
}
SetCursor(0, cursorY + 1);
PrintLetter('\202');
for (i = COLS - 2; i > 0; i--)
{
PrintLetter('\203');
}
PrintLetter('\204');
SetAttr(MENU_TEXT_ATTR);
SetCursor(0, ROWS - NOPTS(menuBottom) - 1);
for (s = menuBottom; *s; s++)
{
PrintString(*s);
SetCursor(0, cursorY + 1);
}
ScreenRefresh();
}
KeySym
BrowseList(unsigned int *curItem, unsigned int maxItems,
unsigned int itemsPerPage, void (*printPage)(unsigned int))
{
int i;
uns16 mem;
int item, page;
KeySym key;
assert(*curItem < maxItems);
item = *curItem % itemsPerPage;
page = *curItem / itemsPerPage;
for (;;)
{
SetCursor(MENU_CURSOR_X, MENU_CURSOR_Y + item);
mem = xyToAttr(cursorX, cursorY);
if (GETCFG(mono))
{
for (i = COLS; i > 0; i--, mem++)
{
SET_ATTR(mem, Reverse[GET_ATTR(mem) & ~FLASH]);
}
}
else
{
for (i = COLS; i > 0; i--, mem++)
{
SET_ATTR(mem, (GET_ATTR(mem) & ~PAPER) | (CYAN << 3));
}
}
ScreenRefresh();
key = GetKey();
mem = xyToAttr(MENU_CURSOR_X, MENU_CURSOR_Y + item);
if (GETCFG(mono))
{
for (i = COLS; i > 0; i--, mem++)
{
SET_ATTR(mem, Reverse[GET_ATTR(mem) & ~FLASH]);
}
}
else
{
for (i = COLS; i > 0; i--, mem++)
{
SET_ATTR(mem, (GET_ATTR(mem) & ~PAPER) | (WHITE << 3) | BRIGHT);
}
}
ScreenRefresh();
switch ((int)key)
{
case XK_Prior:
if (--page < 0)
{
goto home;
}
if (printPage)
{
printPage((unsigned int)page);
}
break;
case XK_Next:
if (item + ++page * itemsPerPage >= maxItems)
{
goto end;
}
if (printPage)
{
printPage((unsigned int)page);
}
break;
case XK_Up:
if (--item < 0)
{
if (page > 0)
{
item = itemsPerPage - 1;
page--;
if (printPage)
{
printPage((unsigned int)page);
}
}
else
{
goto end;
}
}
break;
case XK_Home:
home:
item = 0;
page = 0;
if (printPage)
{
printPage((unsigned int)page);
}
break;
case XK_Down:
if (++item + page * itemsPerPage >= maxItems)
{
goto home;
}
if (item > itemsPerPage - 1)
{
if (page < maxItems / PAGE_SIZE)
{
item = 0;
page++;
if (printPage)
{
printPage((unsigned int)page);
}
}
else
{
goto home;
}
}
break;
case XK_End:
end:
item = (maxItems - 1) % itemsPerPage;
page = (maxItems - 1) / itemsPerPage;
if (printPage)
{
printPage((unsigned int)page);
}
break;
default:
goto quit;
}
}
quit:
*curItem = item + page * itemsPerPage;
return KeyDialog;
}
