/*******************************************************************************
 * Copyright (c) Erik Kunze 1995 - 1999
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * $Id: config2.h,v 1.17 1999/05/11 16:57:15 erik Rel $
 ******************************************************************************/

#ifndef _XZX_CONFIG2_H
#define _XZX_CONFIG2_H

/********************************************************************************
 * Do not change anything below this line
 *******************************************************************************/

#if SIZEOF_CHAR != 1
#error "sizeof(char) is not equal to 8 bit"
#endif

#if SIZEOF_SHORT != 2
#error "sizeof(short) is not equal to 16 bit"
#endif

#if SIZEOF_INT != 4
#error "sizeof(int) is not equal to 32 bit"
#endif

#define EXTERN_Z80_TYPEDEFS
typedef unsigned char	uns8;
typedef unsigned short	uns16;
typedef unsigned int	uns32;
typedef signed char		sgn8;
typedef signed short	sgn16;
typedef signed int		sgn32;

#undef DEBUG_HALT
#undef DEBUG_R_REGISTER
#undef DELAY_EI
#undef NO_ED_TRAPS
#undef BROCKEN_VISUAL_SUPPORT
#define SPEEDUP_TRDOS
#define VIRTUAL_DISK_IMAGES

#if IF1_DRIVES > 8 || IF1_DRIVES < 1
#define IF1_DRIVES		2
#endif

#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO) || defined(XBELL_AUDIO)
#define AUDIO
#endif

#if defined(XBELL_AUDIO) && (defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO))
#undef XBELL_AUDIO
#endif

#if defined(STEREO_AUDIO) && (!defined(AYCHIP_AUDIO) || !defined(OSS_AUDIO))
#undef STEREO_AUDIO
#endif

#if defined(ZX_PRINTER) || defined(IF1_PRINTER) || defined(PLUS3_PRINTER)
#define PRINTER
#endif

#if defined(PLUS3_PRINTER) && !defined(XZX_PLUS3)
#define XZX_PLUS3
#endif

#if (defined(XZX_PENTAGON) || defined(XZX_SCORPION)) && defined(REGISTERED)
#ifndef XZX_TRDOS
#define XZX_TRDOS
#endif
#endif

#if defined(XZX_TRDOS)
#define DISK_DRIVES		4
#elif defined(XZX_PLUS3) || defined(XZX_MGT)
#define DISK_DRIVES		2
#else
#define DISK_DRIVES		0
#endif

#if defined(XZX_TRDOS) || defined(XZX_MGT)
#define EVENT_SCHEDULER
#endif

#if !defined(XZX_PENTAGON) && !defined(XZX_SCORPION) && defined(XZX_KMOUSE)
#undef XZX_KMOUSE
#endif

#ifdef DEMO
#undef SPEEDUP_TRDOS
#undef VIRTUAL_DISK_IMAGES
#undef XZX_MF
#undef AUDIO
#undef SPEAKER_AUDIO
#undef AYCHIP_AUDIO
#undef XBELL_AUDIO
#undef STEREO_AUDIO
#undef PRINTER
#undef ZX_PRINTER
#undef IF1_PRINTER
#undef PLUS3_PRINTER
#endif

#ifndef REGISTERED
#undef XZX_TRDOS
#undef XZX_MGT
#undef STEREO_AUDIO
#undef PRINTER
#undef ZX_PRINTER
#undef IF1_PRINTER
#undef PLUS3_PRINTER
#endif

#endif /* ! _XZX_CONFIG2_H */

/* EOF *************************************************************************/
