;*L+
;DSKHNDLR.ZXATASP - IDE via 8255 (MODE 0 only)
;Ostatnia modyfikacja: 03-05-27; (C) Jarek Adamski
;*L-
;16b access in ports:
;#009F - low byte
;#019F - high byte
;#029F - b0:A0, b1:A1, b2:A2, b3:WR, b4:RD, b5:CS b6:0, b7:0
;#039F - 8255 control
;the 8255 works in mode 0, what gives 37T per byte (90kB/s for 3.5MHz)

;030527 based on IDE8255.GI; (C) Jarek Adamski
;
;IDE port addresses for #29F
as_B0	EQU	%00100000
as_B1	EQU	%00100001
as_B2	EQU	%00100010
as_B3	EQU	%00100011
as_B4	EQU	%00100100
as_B5	EQU	%00100101
as_B6	EQU	%00100110
as_B7	EQU	%00100111
as_RD	EQU	%00110000
as_WR	EQU	%00101000
;bitchanges for #39F
aslRD	EQU	%00001001	;/RD goes low
ashRD	EQU	%00001000
aslWR	EQU	%00000111
ashWR	EQU	%00000110
;
asmins	EQU	30		;ilo minut do automatycznego parkowania

ashere	JP	asinte		;wejcie przerwa - co 1s
	JP	asmain
	DEFW	#A002		;numer wersji
	DEFW	asnext-ashere,ashere,aspart1-aspart,aspart
	DEFM	'DSKHNDLR'
	DEFM	'ZXATASP '
;
;przesunicia w cylindrach poszczeglnych partycji obu dyskw,
;naley je wczyta na pocztku
aspart	DEFW	#0000,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#0000,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
astime	DEFW	60*asmins
aspart1	EQU	$

;wysanie wartoci E do portu D
asout	LD	BC,#029F
	OUT	(C),D
	INC	B
	LD	A,#80		;wszystkie wyjcia
	OUT	(C),A
	LD	B,#00
	OUT	(C),E
	LD	B,#03
	LD	A,aslWR
	OUT	(C),A
	LD	A,ashWR
	OUT	(C),A
	RET
;procedura obsugujca przerwanie (nie wymagane przechowanie rejestrw AF,HL)
asinte	DEC	(IX+astime-aspart)
	JP	NZ,asnext
	DEC	(IX+astime-aspart+1)
	LD	A,#E0		;komenda >HDPARK<
	CALL	Z,ascom
	JP	asnext		;przekazanie przerwania do nastpnego moduu


;komenda
ascom	PUSH	AF
	LD	BC,#039F
	LD	A,#92		;AB inputs
	OUT	(C),A
	DEC	B
	LD	A,as_B7
	OUT	(C),A
	INC	B
	LD	A,aslRD
	OUT	(C),A
	LD	B,0
ascom1	IN	A,(C)		;#B7
	AND	A
	JP	M,ascom1	;zaptlenie do uzyskania gotowoci; JP szybciej
	LD	B,#03
	LD	A,ashRD
	OUT	(C),A
	LD	A,#80		;AB outputs
	OUT	(C),A
	POP	AF		;w A komenda
	LD	B,#00
	OUT	(C),A		;#B7, wysanie komendy
	LD	B,#03
	LD	A,aslWR
	OUT	(C),A
	LD	A,ashWR
	OUT	(C),A
	LD	A,#92		;AB inputs
	OUT	(C),A
	LD	A,aslRD
	OUT	(C),A
	LD	B,#00
ascom2	IN	A,(C)		;#B7
	BIT	7,A
	JP	NZ,ascom2	;zaptlenie do uzyskania gotowoci; JP szybciej
	AND	#25		;maska bdw
	PUSH	AF
	LD	B,#03
	LD	A,ashRD
	OUT	(C),A
	POP	AF
	RET

;wybieranie waciwego sektora
asini	PUSH	HL
	LD	HL,60*asmins	;czas do zaparkowania
	LD	(IX+astime-aspart+0),L
	LD	(IX+astime-aspart+1),H
	PUSH	BC
	LD	BC,#039F
	LD	A,#92		;AB inputs
	OUT	(C),A
asini1	LD	B,#02		;because the loop
	LD	A,as_B7
	OUT	(C),A
	INC	B
	LD	A,aslRD
	OUT	(C),A
	LD	B,#00
	IN	A,(C)		;#B7
	BIT	7,A
	JR	NZ,asini1
	POP	BC
	PUSH	BC
	LD	A,C
	AND	#10		;Master lub Slave
	OR	B		;mamy unit, dodajemy stron
	OR	#A0		;sygnaturka (podobno)
	PUSH	DE
	LD	E,A
	LD	D,as_B6
	CALL	asout		;#B6, wybieramy dysk i stron
;	LD	BC,#039F
	LD	A,#92		;AB inputs
	OUT	(C),A
asini2	LD	B,#02
	LD	A,as_B7
	OUT	(C),A
	INC	B
	LD	A,aslRD
	OUT	(C),A
	LD	B,#00
	IN	A,(C)		;#B7
	BIT	7,A
	JR	NZ,asini2
	LD	DE,as_B2*256+#01
	CALL	asout		;#B2, ilo sektorw
	POP	DE
	PUSH	DE
	LD	D,as_B3
	CALL	asout		;#B3, numer sektora
	POP	DE
	POP	BC
	LD	A,C		;w C numer partycji (po 16 na dysk)
	AND	#1F
	ADD	A,A
	LD	C,A
	LD	B,#00
	ADD	IX,BC		;pobranie przesunicia partycji
	LD	A,(IX+0)
	ADD	A,D		;cylinder
	LD	E,A
	LD	D,as_B4
	CALL	asout		;#B4, LO cieki
	LD	A,(IX+1)
	ADC	A,#00		;dodanie przeniesienia
	LD	E,A
	LD	D,as_B5
	CALL	asout		;#B5, HI cieki
	POP	HL
	RET


aswant	LD	E,A		;komenda wymaga gotowoci, przechowana w E
	LD	B,#03
	LD	A,#92		;AB inputs
	OUT	(C),A
aswan1	LD	B,#02
	LD	A,as_B7
	OUT	(C),A
	LD	A,as_B7 .OR. as_RD
	OUT	(C),A
	LD	B,#00
	IN	A,(C)		;#B7
	RLCA
	JR	C,aswan1	;zaptlenie do uzyskania gotowoci
	LD	D,as_B7
	CALL	asout
	LD	A,#92		;AB inputs
	OUT	(C),A
	LD	A,aslRD
	OUT	(C),A
aswan2	LD	B,#00
	IN	A,(C)		;#B7
	AND	A
	JP	M,aswan2
	BIT	3,A
	RET	NZ
	AND	#25		;maska bdu
	JR	Z,aswan2	;bez bdu
	POP	AF		;bd
	RET

asmain	AND	#0F
	JR	NZ,asinfo
asinit	LD	BC,#039F
	LD	A,#92		;AB inputs
	OUT	(C),A
	LD	DE,#0000	;zwraca: B-ilo partycji, DE-maska
asi1	LD	B,#02
	LD	A,as_B7
	OUT	(C),A		;all disabled - command register
	DEC	DE
	LD	A,E
	OR	D
	RET	Z
	LD	A,as_B7 .OR. as_RD
	OUT	(C),A
	LD	B,#00
	IN	A,(C)		;#B7
	RLCA
	JR	C,asi1
	PUSH	IX		;count partitons with shifts <#FFFF
	POP	HL
	LD	BC,#1000
ati3	LD	A,(HL)		;test for #FFFF
	INC	HL
	AND	(HL)
	INC	HL
	CP	#FF		;resets Cy only when #FF was
	JR	NC,ati4
	INC	C		;Cy not changed
ati4	RR	D
	RR	E
	DJNZ	ati3
	LD	B,C
	RET
atinic	LD	DE,0
	LD	B,E
	RET
	
asinfo	DEC	A		;funkcja 1 - ustawienie przesunicia partycji
	JR	NZ,asread
	LD	A,C		;w C numer partycji (po 16 na dysk)
	AND	#1F
	ADD	A,A
	LD	C,A
	LD	B,#00
	ADD	IX,BC		;ustalenie przesunicia partycji
	LD	(IX+0),L
	LD	(IX+1),H
;	LD	BC,#C401	;odczyta to z danych napdu???
;	LD	DE,#0411	;D-strony, E-sektory
	LD	HL,#0200	;wielko sektora
	RET

asread	PUSH	AF
	CALL	asini		;zawsze poprawnie
	POP	AF
	LD	B,A		;C=#9F must be
ascd	DJNZ	aswrit
asg0	LD	A,#20
	CALL	aswant
asg1	LD	B,#02
	LD	A,as_B0
	OUT	(C),A
	LD	A,as_B0 .OR. as_RD
	OUT	(C),A
	LD	B,#00
	INI			;oczyt z dysku
	LD	B,#01
	INI			;odczyt z bufora
asg2	LD	B,#02
	LD	A,as_B7
	OUT	(C),A
	LD	A,as_B7 .OR. as_RD
	OUT	(C),A
	LD	B,#00
	IN	A,(C)		;#B7
	AND	A
	JP	M,asg2
	BIT	3,A
	JP	NZ,asg1
	AND	#01
	RET

aswrit	DJNZ	aschck
asp0	LD	A,#30
	CALL	aswant
asp1	LD	B,#03
	LD	A,#80		;all outputs
	OUT	(C),A
	LD	B,#01
	LD	E,(HL)
	INC	HL
	LD	A,(HL)
	INC	HL
	OUT	(C),A
	LD	D,as_B0
	CALL	asout
asp2	LD	B,#03
	LD	A,#92		;AB inputs
	OUT	(C),A
	DEC	B
	LD	A,as_B7
	OUT	(C),A
	LD	A,as_B7 .OR. as_RD
	OUT	(C),A
	LD	B,#00
	IN	A,(C)		;#B7
	AND	A
	JP	M,asp2
	BIT	3,A
	JP	NZ,asp1
	AND	#21
	RET

aschck	DJNZ	asform
asv0	LD	A,#20
	CALL	aswant
asv1	LD	B,#02
	LD	A,as_B0
	OUT	(C),A
	LD	A,as_B0 .OR. as_RD
	OUT	(C),A
	LD	B,#00
	IN	A,(C)		;modszy bajt (z dysku)
	SUB	(HL)
	JR	NZ,asbad	;jeli le, to A<>0
	INC	HL
	INC	B
	IN	A,(C)		;starszy bajt (z bufora)
	SUB	(HL)
	JR	NZ,asbad
	INC	HL
asv2	LD	B,#02
	LD	A,as_B7
	OUT	(C),A
	LD	A,as_B7 .OR. as_RD
	OUT	(C),A
	LD	B,#00
	IN	A,(C)		;#B7
	AND	A
	JP	M,asv2
	BIT	3,A
	JP	NZ,asv1
	AND	#01
	RET

asbad	LD	B,#02
	LD	A,as_B7
	OUT	(C),A
	RET

asform	OR	#FF		;formatowania nie bdzie
	RET

asnext	EQU	$		;wejcie do nastpnego urzdzenia

;
;	End of file DSKHNDLR.ZXATASP.GI
;
