*L+
;DISKHNDLR.FDCSVI.GI - a disk driver for SVI 738 X'PRESS
;Last modified: 2002-10-07; (C) Jarek Adamski
*L-

;021007	formatting added, but not tested; off time is 20s
;021005	removed need for IY=fvr0

;rejestry kontrolera dyskowego
fvr0	EQU	#7FB8
fvr1	EQU	#7FB9
fvr2	EQU	#7FBA
fvr3	EQU	#7FBB
fvr4	EQU	#7FBC

fvfw	EQU	#E5		;sector filler

fvtoff	EQU	20		;time to stop in secons

fvhere	JP	fvinte
	JP	fvmain
	DEFW	#7002
	DEFW	fvnext-fvhere,fvhere,fvcode-fvdata,fvdata
	DEFM	'DSKHNDLR'
	DEFM	'FDCSVI  '

fvdata	EQU	$
fvtbl0	DEFB	0,#18,#01,1	;trach, step, drive, exists
fvtbl1	DEFB	0,#18,#02,1
fvtime	DEFB	0

fvcode	EQU	$

;interrupt service
fvinte	BIT	3,(IX+2)
	JR	NZ,fvintm
	BIT	3,(IX+2+fvtbl1-fvtbl0)
	JR	Z,fvint1
fvintm	DEC	(IX+fvtime-fvtbl0)
	JR	NZ,fvint1
	RES	3,(IX+2)
	RES	3,(IX+2+fvtbl1-fvtbl0)
	LD	A,#7F
	CALL	fvmain		;do motor off
fvint1	JP	fvnext		;interrupt chain

	COND	0
	BIT	1,(IX+17)	;dla SDN=#02 lub #03 jest inaczej
	JR	Z,fvi1
	LD	A,D
	SUB	(IX+18)
	RET	C
	LD	D,A
	SET	2,C
	BIT	0,(IX+17)
	RET	NZ
	CPL
	ADD	A,(IX+18)
	LD	D,A
	RET
	ENDC

;sector data initialization
fvini	SET	3,(IX+2)	;motor on
	LD	A,(IX+2)	;drive number
	BIT	0,B		;what side?
	JR	Z,fvini1
	SET	2,A		;select second side

	COND	0
	RET	Z		;no delay, when reset (motor on before)
	LD	BC,#9C40
fvdelay	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,fvdelay
	ENDC

fvini1	LD	(fvr4),A
	LD	A,E
	LD	(fvr2),A
	LD	A,(IX)
	LD	(fvr1),A	;recall track number
	CP	D
	RET	Z
	LD	A,D
	AND	A
	JR	Z,fvhome
	LD	(fvr3),A
	LD	A,(IX+1)
	CALL	fvcom
	BIT	4,A
	RET	Z
fvhome	LD	A,(IX+1)
	AND	#0B
	CALL	fvcom
	BIT	2,A
	JR	Z,fvhome
	RET


;main entry
fvmain	PUSH	AF
	LD	A,#5D		;open the FDC page
	OUT	(#A8),A
	POP	AF
	CALL	fvfun
	PUSH	AF
	LD	A,#55		;back to RAM page
	OUT	(#A8),A
	POP	AF
	RET

fvfun	AND	#0F		;functions 4..31 not implemented
	JR	NZ,fvoff

fvinit	LD	DE,#0000	;in D drive counter, in E drives mask
	LD	BC,fvtbl1-fvtbl0
	ADD	IX,BC
	CALL	fviis
	LD	BC,fvtbl0-fvtbl1
	ADD	IX,BC
	CALL	fviis
	XOR	A
	LD	(fvr4),A	;lights off
	LD	B,D		;ilo napdw jest w B
	LD	D,#00		;maska dostpnych napdw jest w DE
	RET

;checking drive
fviis	SLA	E		;kolejny napd
	LD	(IX+3),#00	;drive not present as default
	LD	A,(IX+2)
	LD	(fvr4),A
	LD	A,(IX+1)
	AND	#03		;track0 command
	CALL	fvcom
	BIT	2,A
	RET	Z		;return when not done
	LD	(IX+3),#18	;default Gap3 for formatting
	SET	0,E		;exists
	INC	D		;one more found
	RET

fvoff	CP	#0F
	JR	NZ,fvset
	LD	A,#D0
	LD	(fvr0),A	;drive deactivation (called from INT)
	XOR	A
	LD	(fvr4),A
	RET

;disk access
fvset	LD	(IX+fvtime-fvtbl0),fvtoff	;time to off - moved from #FFFC
	BIT	0,C
	JR	Z,fvset1
	PUSH	BC
	LD	BC,fvtbl1-fvtbl0
	ADD	IX,BC		;second drive
	POP	BC
fvset1	DEC	A
	JR	NZ,fvrwop
;setting needed for formatting
	LD	(IX+3),H	;Gap3 for formatting
	RET

fvrwop	PUSH	AF
	CALL	fvini		;NZ, when the >terr< is done
	POP	AF		;B=function number
	CALL	fvread
	PUSH	AF
	LD	A,(fvr1)	;read current track
	LD	(IX),A		;store last track
	POP	AF
	RET

fvread	DEC	A
	JR	NZ,fvwrit
fvg0	LD	A,#80
	CALL	fvwait
	RET	NZ
fvg1	LD	A,(fvr3)
	LD	(DE),A
	INC	DE
fvg2	BIT	6,(HL)
	JR	Z,fvg1
	BIT	7,(HL)
	JR	Z,fvg2
	CALL	fvcom1
	AND	#1C
	RET	Z
	LD	HL,#FFF1
	INC	(HL)		;!
	RET

fvwrit	DEC	A
	JR	NZ,fvchck
fvp0	LD	A,#A0
	CALL	fvwait
	RET	NZ
	LD	A,(DE)
fvp1	DEC	L
	LD	(HL),A
	INC	L
	INC	DE
	LD	A,(DE)
fvp2	BIT	6,(HL)
	JR	Z,fvp1
	BIT	6,(HL)
	JR	Z,fvp1
	BIT	6,(HL)
	JR	Z,fvp1
	BIT	6,(HL)
	JR	Z,fvp1
	BIT	7,(HL)
	JR	Z,fvp2
	CALL	fvcom1
	AND	#7C
	RET	Z
	LD	HL,#FFF2
	INC	(HL)		;!
	RET

fvchck	DEC	A
	JR	NZ,fvform
fvv0	LD	A,#80
	CALL	fvwait
	RET	NZ
	LD	A,(DE)
fvv1	DEC	L
	CP	(HL)
	JR	NZ,fvv3
	INC	L
	INC	DE
	LD	A,(DE)
fvv2	BIT	6,(HL)
	JR	Z,fvv1
	BIT	7,(HL)
	JR	Z,fvv2
	CALL	fvcom1
	AND	#1C
	RET
fvv3	LD	A,#D0
	CALL	fvcom
	OR	#3F
	RET

fvwait	DI
	LD	(fvr0),A
	EX	DE,HL
	LD	HL,fvr4
	LD	B,9
fvw0	DJNZ	fvw0		;wait after command
	LD	BC,0		;time counter
fvw1	BIT	6,(HL)
	RET	Z
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,fvw1
fvw2	BIT	6,(HL)
	RET	Z
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,fvw2
	LD	A,#D0
	CALL	fvcom
	CALL	fvhome
	LD	A,#05
	AND	A
	RET

fvcom	LD	(fvr0),A
fvcom1	LD	A,6
fvco1	DEC	A
	JR	NZ,fvco1
fvco2	LD	A,(fvr0)
	BIT	0,A
	RET	Z
	JR	fvco2

	COND	dskhnd&#20	;czy ma by formatowanie

fvform	OR	#FF		;nie ma formatowania
	RET

	ELSE

fvform	DEC	A
	JP	NZ,fvnic
fvf0	EXX
	LD	D,#28		;Gap 1 - 40B wystarczy
	LD	HL,fvr4
	EXX
	LD	B,E		;ilo sektorw
	PUSH	BC
	LD	A,#F0		;formatowanie bdzie inaczej
	CALL	fvwait		;HL=fvr4, DE=HL, BC=?
	DEC	L
	LD	(HL),#4E	;first byte goes this way to have some time
	POP	BC
	EX	DE,HL		;HL=HL, DE=fvr3
fvf1	EXX
	CALL	fvfsec		;to ma by bez bdu
	LD	D,(IX+3)	;Gap 3 (zmienna dugo)
	EXX
	RET	NZ
	DJNZ	fvf1
	EXX
	LD	DE,#004E	;Gap 4
	CALL	fvgap		;tu bd nie przeszkadza
	EXX
	XOR	A
	RET

fvgap	CALL	fvfj		;to wynika z istnienia fvferr
	RET
fvfsec	LD	E,#4E		;Gap 1 albo Gap 3
	CALL	fvfj
	LD	DE,#0C00	;rozbiegwka
	CALL	fvfj
	LD	DE,#03F5	;zapis #A1
	CALL	fvfj
	LD	DE,#01FE	;znacznik adresu ID
	CALL	fvfj
	LD	B,#04		;zapis ID
	CALL	fvfm		;w A ostatni bajt - dugo sektora
	LD	DE,#01F7	;zapis CRC
	CALL	fvfj
	LD	DE,#164E	;Gap 2 - zawsze 22 bajty
	CALL	fvfj
	LD	DE,#0C00	;rozbiegwka
	CALL	fvfj
	LD	DE,#03F5	;zapis #A1
	CALL	fvfj
	LD	DE,#01FB	;znacznik adresu danych
	CALL	fvfj
	LD	DE,#8000+fvfw	;sektor 128B, E-wypeniacz sektora
	CALL	fvfj
;	EXX
;	DEC	HL		;ostatni bajt to dugo
;	LD	A,(HL)		;A przekazane z fvfm
;	INC	HL
;	EXX
	AND	A
	JP	Z,fvfcrc
	LD	D,#80		;sektor 256B
	CALL	fvfj
	DEC	A
	JP	Z,fvfcrc
	CALL	fvfj		;sektor 512B
	DEC	A
	JP	Z,fvfcrc
	CALL	fvfj		;sektor 1KB
	CALL	fvfj
fvfcrc	LD	DE,#01F7
fvfj	BIT	7,(HL)		;HL=fvr4 - nie uywa A
	JR	NZ,fvferr
	BIT	6,(HL)
	JR	Z,fvfj1
	BIT	6,(HL)
	JR	Z,fvfj1
	BIT	6,(HL)
	JR	Z,fvfj1
	BIT	6,(HL)
	JR	NZ,fvfj
fvfj1	DEC	L
	LD	(HL),E
	INC	L
	DEC	D
	JP	NZ,fvfj
	RET			;ok: Z=1

fvfm	BIT	7,(HL)		;HL=fvr4;wysanie bajtw spod adresu
	JR	NZ,fvferr
	BIT	6,(HL)
	JR	Z,fvfm1		;oczekiwanie na moliwo
	BIT	6,(HL)
	JR	Z,fvfm1		;oczekiwanie na moliwo
	BIT	6,(HL)
	JR	Z,fvfm1		;oczekiwanie na moliwo
	BIT	6,(HL)
	JR	NZ,fvfm		;oczekiwanie na moliwo
fvfm1	EXX
	LD	A,(HL)
	LD	(DE),A		;A potrzebne do dugoci sektora
	INC	HL
	EXX
	DEC	B
	JP	NZ,fvfm		;skok, gdy B>0
	RET			;ok: Z=1

fvferr	POP	AF		;przystosowa fverr !!!!
	LD	A,(fvr0)	;Z=0
	AND	#7C		;maska bdu
	RET

fvnic	OR	#FF
	RET

	ENDC

fvnext	EQU	$

;
;	End of file DSKHNDLR.FDCSVI.GI
;
