*L+
;Modu DSKHNDLR.FDCPL3 (ZX Spectrum +3)
;Ostatnia modyfikacja: 01-05-06; (C) Jarek Adamski
*L-
;obsuga stacji dyskw w ZX Plus 3
;	- moe by uywana niezalenie od systemu

;  Wejcie:	   Wyjcie:
;
; A  - komenda			
; B  - strona	 poprawnie:	
; C  - unit	 A = 0, Z = 1	
; D  - cylinder		
; E  - sektor	 bdnie:	
; HL - adres	 A > 0, Z = 0	
;
;Uywa: IX, HL',DE',BC'; DE' tylko przy formatowaniu

;010506	funkcja 0 sprawdza obecno kontrolera 765A
;000720	adres portu przed OUTI jest #40FD
;000122	czytanie sektora dziaa - dziwi tylko ST0=#40 i ST1=#80
;000120	funkcja 1 okrela czas przesuwu gowicy (B)
;000112	nowa struktura nagwka - wywoywaanie z podaniem IX
;990703	poprawki po przeczytaniu opisu i8272
;990701	zacztek z FDCSAM.GI (C) Jarek Adamski

;#1FFD	-b3=1:MOTOR ON
;#2FFD	-765A status: b7=1-gotowy, b5=1-dane
;#3FFD	-765A data
fpfw	EQU	#E5		;wypeniacz formatowanych sektorw

fphere	JP	fpnext		;przekazanie przerwa do nastpnego moduu
	JP	fpmain		;gwne wejcie do moduu
	DEFW	#6002		;numer wersji
	DEFW	fpnext-fphere,fphere,fptble-fptbl0,fptbl0
	DEFM	'DSKHNDLR'
	DEFM	'FDCPL3  '
;kolejno: 	track,	step,	unit,	fgap,	rwgap,	seclen,	secno,	mask
fptbl0	DEFB	#FF,	#EF,	#00,	0,	#2A,	#03,	#05,	#01
fptbl1	DEFB	#FF,	#EF,	#01,	0,	#2A,	#03,	#05,	#02
fptble	EQU	$

;ustawiony bit 7 w (IX+0) oraz (IX+9) oznacza wyczony silnik

fpmon	RES	7,(IX)		;silnk wczony
	LD	BC,#1FFD
	LD	A,#0C		;MOTOR ON - wcza RAM - niebezpiecznie???
	OUT	(C),A		;eby /READY byo aktywne
	RET
;
fpwait	DI
	PUSH	AF
	CALL	fpmon
	LD	A,D
	SRL	A
	CP	(IX+0)		;porwnanie z poprzeni ciek
	JR	Z,fpw1
;	LD	(IX+0),A
	LD	A,#0F		;SEEK
	CALL	fpcom
	LD	A,(IX+2)	;UNIT - gowica 0
	CALL	fpout
	LD	A,D
	SRL	A
	CALL	fpout
fpw0	CALL	fpsis		;zwraca ST0 w A i PCN w B
;	LD	(#4022),A
;	LD	(#4024),BC
	XOR	#20		;bo b5=1 gdy zakoczono pozycjonowanie
	XOR	(IX+2)		;interesuje przerwanie od danego napdu
	AND	#FB		;ignorujemy gowic - w sumie i tak bya 0
;	LD	(#4023),A
	JR	NZ,fpw0		;jest
	LD	(IX+0),B	;cylinder podany przez SIS
;	AND	#C0		;sprawdzamy zaawansowanie operacji
;	XOR	#80
fpw1	POP	AF
	CALL	fpcom		;komenda
	LD	A,D
	ADD	A,A
	ADD	A,A
	AND	#04
	OR	(IX+2)		;UNIT
	CALL	fpout		;gowica i napd (do uycia)
	LD	A,D
	SRL	A
	CALL	fpout		;cylinder
	LD	A,D
	AND	#01
	CALL	fpout		;gowica (do porwnywania z ID) - s bdne IDy
	LD	A,E		;pierwszy sektor
	CALL	fpout
	LD	A,(IX+5)
	CALL	fpout		;rozmiar sektora
	LD	A,E
	CALL	fpout		;ostatni sektor
	LD	A,(IX+4)	;szczelina czytania
	CALL	fpout
	LD	A,#FF		;tak zalecaj w instrukcji
	CALL	fpout		;bajt bez sensu
	LD	DE,#0000
	LD	BC,#2FFD
fpw2	IN	A,(C)		;to tak moe w nieskoczono
	RET	M
	DEC	DE
	LD	A,E
	OR	D
	JR	NZ,fpw2
fpmoff	SET	7,(IX+0)	;silik wyczony
	LD	BC,#1FFD
	LD	A,#04		;MOTOR OFF - wcza RAM - niebezpiecznie???
	OUT	(C),A		;eby /READY byo nieaktywne
	RET


;faza kocowa zapisu i czyania sektora
fpstat	CALL	fpin		;ST0
;	LD	(#4000),A
	AND	#88		;zakoczenie operacji i brak gotowoci
	LD	E,A
	CALL	fpin		;ST1
;	LD	(#4001),A
	AND	#37
	OR	E
	LD	E,A
	CALL	fpin		;ST2
;	LD	(#4002),A
	AND	#33
	OR	E
;	LD 	E,A
	CALL	fpinb		;TRK
	CALL	fpinb		;HED
	CALL	fpinb		;SEC
	CALL	fpinb		;SIZ
;	EI
;	LD	A,E
;	LD	(#4003),A
	AND	A
	RET	Z
fperr	CALL	fphome
	OR	#7F		;i tak bd, bo nie znaleziony sektor
	RET

fphome	LD	A,#07		;przesuwanie na TR0
	CALL	fpcom
	LD	A,(IX+2)	;numer napdu
	CALL	fpout
	LD	DE,#4000
	LD	(IX+0),E	;cieka zerowa
fphom1	LD	A,#04		;sense drive status
	CALL	fpcom
	LD	A,(IX+2)	;numer napdu
	CALL	fpout
	CALL	fpin		;ST3
	CPL
	AND	#10		;Z=osignita cieka 0
	RET	Z
	DEC	DE
	LD	A,E
	OR	D
	JR	NZ,fphom1	;Z=brak napdu
	OR	#7F		;bd
	RET

fpsis	LD	A,#08
	CALL	fpcom
	CALL	fpin
	JP	fpinb

;sprawdzenie gotowci i wysanie bajtu z A do rej. danych z czytaniem mieci
fpcom	LD	BC,#2FFD
	IN	B,(C)
	JP	P,fpcom		;moe si tu zawiesi???
	BIT	6,B
	LD	B,#3F
	JR	NZ,fpc1		;skok, gdy wczenej co do odczytania
	OUT	(C),A
	RET
fpc1	IN	B,(C)		;odczytanie mieci
	JP	fpcom		;ponowienie prby

;sprawdzenie gotowci i wysanie bajtu z A do rej. danych
fpout	LD	BC,#2FFD
fpo1	DEFB	#ED,#70		;IN F,(C)
	JP	P,fpo1		;moe si tu zawiesi???
	LD	B,#3F
	OUT	(C),A
	RET

;sprawdzenie gotowci i pobranie bajtu do A z rej. danych
fpin	LD	BC,#2FFD
fpin1	DEFB	#ED,#70		;IN F,(C)
	JP	P,fpin1		;moe si tu zawiesi???
	LD	B,#3F
	IN	A,(C)
	RET

;sprawdzenie gotowci i wysanie bajtu z A do rej. danych
fpinb	LD	BC,#2FFD
fpinb1	DEFB	#ED,#70		;IN F,(C)
	JP	P,fpinb1	;moe si tu zawiesi???
	LD	B,#3F
	IN	B,(C)
	RET

fpmain	EQU	$
;	LD	(#4040),HL
;	LD	(#4042),DE
;	LD	(#4044),BC
;	LD	(#4046),A
	AND	#0F		;funkcje 4..31 nie implementowane
	JR	NZ,fpset
;inicjacja - w IX podany adres bufora
fpinit	EQU	$
	IF	dskhnd & 1	;czy w ROM
	PUSH	HL		;inicjacja tabeli standardowymi wartociami
	PUSH	DE
	PUSH	IX		;IX podane przy wywoaniu
	POP	DE
	LD	HL,fptbl0
	LD	BC,fptble-fptbl0
	LDIR
	POP	DE
	POP	HL
	ENDIF
fpich	LD	BC,#2FFD	;czy w ogle jest kontroler?
	IN	D,(C)
	INC	D
	JR	NZ,fpije
	LD	B,#3F
	IN	D,(C)
	INC	D
	JR	NZ,fpije
	DEC	A
	JR	NZ,fpich	;B=0
	LD	E,D
	JR	fpiex
fpije	CALL	fpset2		;programowanie czasw kontrolera
	CALL	fpmon		;wczenie silnika
	LD	DE,#0000	;w D liczymy napdy, w E jest maska
	LD	BC,8
	ADD	IX,BC
	CALL	fpiis
	LD	BC,-8
	ADD	IX,BC
	CALL	fpiis
;	CALL	fpsis
fpiex	LD	B,D		;ilo napdw jest w B
	LD	D,#00		;maska dostpnych napdw jest w DE
	RET
fpiis	SLA	E		;kolejny napd
	LD	(IX+3),#00	;=0 na razie nie ma
	PUSH	DE
	CALL	fphome
	POP	DE
	RET	NZ
	LD	(IX+3),#16	;domylna dugo przerwy Gap3
	SET	0,E		;jest
	INC	D		;znaleziony jeszcze jeden
	RET

fpset	BIT	0,C
	JR	Z,fpset1
	PUSH	BC
	LD	BC,8
	ADD	IX,BC
	POP	BC
fpset1	DEC	A
	JR	NZ,fpread
;ustawienia potrzebne przy formatowaniu
	LD	(IX+3),H	;przerwa dla formatowania Gap3
	LD	(IX+4),L	;przerwa dla odczytu/zapisu
	LD	(IX+5),D	;dugo sektora
	LD	(IX+6),E	;ilo sektorw
	LD	A,B		;czas kroku [ms]
	NEG
	ADD	A,A
	ADD	A,A
	ADD	A,A
	OR	#0F		;maksymalny headunload
	LD	(IX+1),A
fpset2	LD	A,#03		;specify
	CALL	fpcom
	LD	A,(IX+1)
	CALL	fpout
	LD	A,#0F		;minimalny headload, bez DMA
	JP	fpout

fpread	PUSH	AF		;przygotowanie wartoci w D
	LD	A,D		;cylinder
	ADD	A,A
	OR	B		;strona
	LD	D,A
	POP	AF		;A=numer funkcji
	DEC	A
	JR	NZ,fpwrit
fpg0	LD	A,#66		;czytanie
	CALL	fpwait		;w DE dugo bloku
	LD	DE,#203F
	AND	D
	JR	Z,fpg4		;gdy od razu faza kocowa
fpg1	LD	B,E
	INI
	LD	B,#2F
fpg3	IN	A,(C)
	JP	P,fpg3
	AND	D
	JP	NZ,fpg1
fpg4	JP	fpstat		;faza kocowa

fpwrit	DEC	A
	JR	NZ,fpchck
fpp0	LD	A,#65		;zapis sektora
	CALL	fpwait
	LD	DE,#2040	;#40 jest zmniejszane do #3F przed OUT w OUTI
	AND	D
	JR	Z,fpp4		;gdy od razu faza kocowa
fpp1	LD	B,E
	OUTI
	LD	B,#2F
fpp3	IN	A,(C)
	JP	P,fpp3
	AND	D
	JP	NZ,fpp1
fpp4	JP	fpstat		;faza kocowa

fpchck	DEC	A
	JR	NZ,fpform
fpv0	LD	A,#66		;czytanie
	CALL	fpwait		;w DE dugo bloku
	LD	DE,#203F
	AND	D
	JR	Z,fpv4		;gdy od razu faza kocowa
fpv1	LD	B,E
	IN	A,(C)
	SUB	(HL)
	JR	NZ,fpv5
	INC	HL
	LD	B,#2F
fpv3	IN	A,(C)
	JP	P,fpv3
	AND	D
	JP	NZ,fpv1
fpv4	JP	fpstat		;faza kocowa
fpv5	LD	B,E		;tu kontynuacja ptli, gdy bd
	IN	A,(C)		;odczyt dla zasady
	LD	B,#2F
fpv7	IN	A,(C)
	JP	P,fpv7
	AND	D
	JP	NZ,fpv5
	CALL	fpstat		;faza kocowa
	OR	#3F		;bd weryfikacji
	RET

fpform	DEC	A
	JP	NZ,fpnic

	IF	dskhnd&#0020	;czy obci formatowanie?

	OR	#FF
	RET

	ELSE

;765A formatuje inaczej ni 1770 - jest to podobne do zapisu sektora
fpf0	OR	#FF
	RET

	ENDIF

	RET
fpnic	OR	#FF
	RET
fpnext	EQU	$
;
;	End of file DSKHNDLR.FDCPL3.GI
;
