;*L+
;DSKHNDLR.ATOM - dyski IDE w portach #F5..#F, dostp 16b
;Ostatnia modyfikacja: 03-06-29; (C) Jarek Adamski
;*L-

;	rozmiar dysku odczytywany komend dysku
;030629	na podstawie ATBUS.GI; (C) Jarek Adamski
;#F5 - ustawienie portu, b0..b2-ATA0..ATA2, b3-/CS0, b4-/CS1, b5-/RESET
;#F6 - odczyt H z dysku, L do bufora; zapis H do bufora
;#F7 - odczyt L z bufora; zapis L do dysku, H z bufora
;
;Caution! Bytes in B-DOS sectors have reversed H<-->L
revers	EQU	0		;0 for CPM22QED, 1 for B-DOS
;
aomins	EQU	30		;ilo minut do automatycznego parkowania

aohere	JP	aointe		;wejcie przerwa - co 1s
	JP	aomain
	DEFW	#A002		;numer wersji
	DEFW	aonext-aohere,aohere,aopart1-aopart,aopart
	DEFM	'DSKHNDLR'
	DEFM	'ATOM    '
;
;przesunicia w cylindrach poszczeglnych partycji obu dyskw,
;naley je ustawi na pocztku
aopart	DEFW	#0000,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#0000,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
aotime	DEFW	60*aomins
aopart1	EQU	$

;procedura obsugujca przerwanie (nie wymagane przechowanie rejestrw AF,HL)
aointe	DEC	(IX+aotime-aopart)
	JP	NZ,aonext
	DEC	(IX+aotime-aopart+1)
	LD	A,#E0		;komenda >HDPARK<
	CALL	Z,aocom
	JP	aonext		;przekazanie przerwania do nastpnego moduu


;komenda
aocom	PUSH	AF
	LD	A,#37		;#B7
	OUT	(#F5),A
aocom1	IN	A,(#F6)		;do bufora
	IN	A,(#F7)		;z bufora
	AND	A
	JP	M,aocom1	;zaptlenie do uzyskania gotowoci; JP szybciej
	POP	AF		;w A komenda
	OUT	(#F7),A		;wysanie komendy
aocom2	IN	A,(#F6)		;do bufora
	IN	A,(#F7)		;z bufora
	BIT	7,A
	JP	NZ,aocom2	;zaptlenie do uzyskania gotowoci; JP szybciej
	AND	#25		;maska bdw
	RET

;wybieranie waciwego sektora
aoini	PUSH	HL
	LD	HL,60*aomins	;czas do zaparkowania
	LD	(IX+aotime-aopart+0),L
	LD	(IX+aotime-aopart+1),H
	LD	A,#37		;#B7
	OUT	(#F5),A
aoini1	IN	A,(#F6)		;do bufora
	IN	A,(#F7)		;z bufora
	BIT	7,A
	JR	NZ,aoini1
	LD	A,#36		;#B6
	OUT	(#F5),A
	LD	A,C
	AND	#10		;Master lub Slave
	OR	B		;mamy unit, dodajemy stron
	OR	#A0		;sygnaturka (podobno)
	OUT	(#F7),A		;wybieramy dysk i stron
	LD	A,#37		;#B7
	OUT	(#F5),A
aoini2	IN	A,(#F6)
	IN	A,(#F7)
	BIT	7,A
	JR	NZ,aoini2
	LD	A,#32		;#B2
	OUT	(#F5),A
	LD	A,#01
	OUT	(#F7),A		;ilo sektorw
	LD	A,#33		;#B3
	OUT	(#F5),A
	LD	A,E
	OUT	(#F7),A		;numer sektora
	LD	A,#34		;#B4
	OUT	(#F5),A
	LD	A,C		;w C numer partycji (po 16 na dysk)
	AND	#1F
	ADD	A,A
	LD	C,A
	LD	B,#00
	ADD	IX,BC		;pobranie przesunicia partycji
	LD	A,(IX+0)
	ADD	A,D		;cylinder
	OUT	(#F7),A		;LO cieki
	LD	A,#35		;#B5
	OUT	(#F5),A
	LD	A,(IX+1)
	ADC	A,#00		;dodanie przeniesienia
	OUT	(#F7),A		;HI cieki
	POP	HL
	RET


aowant	LD	B,A		;komenda wymaga gotowoci, przechowana w B
	LD	A,#37		;#B7
	OUT	(#F5),A
aowan1	IN	A,(#F6)
	IN	A,(#F7)
	RLCA
	JP	C,aowan1	;zaptlenie do uzyskania gotowoci; JP szybciej
	LD	A,B		;w A komenda
	OUT	(#F7),A
	LD	C,#F7
aowan2	IN	A,(#F6)
	IN	A,(#F7)
	AND	A
	JP	M,aowan2
	BIT	3,A
	RET	NZ
	AND	#25		;maska bdu
	JR	Z,aowan2	;bez bdu
	POP	AF		;bd
	RET


aomain	AND	#0F
	JR	NZ,aoinfo
	COND	dskhnd & #0001
	BIT	4,C		;not for #B0 initiation
	JR	NZ,aoinit
;	PUSH	HL		;needed to read IDE identification data
	LD	HL,aopart
	PUSH	IX
	POP	DE
	LD	BC,aopart1-aopart
	LDIR
;	POP	HL
	ENDC
aoinit	LD	DE,#0000	;zwraca: B-ilo partycji, DE-maska
	LD	B,E
aoi1	DEC	DE
	LD	A,E
	OR	D
	RET	Z
	LD	A,#37		;#B7
	OUT	(#F5),A
	IN	A,(#F6)
	IN	A,(#F7)
	RLCA
	JR	C,aoi1
	LD	A,#34		;#B4
	OUT	(#F5),A
aoi2	LD	A,B
	OUT	(#F7),A
	IN	A,(#F6)
	IN	A,(#F7)
	CP	B
	JR	NZ,aoinic
	DJNZ	aoi2
	LD	A,#2E		;#BE
	OUT	(#F5),A
	LD	A,#02
	OUT	(#F7),A
;	LD	A,#37		;#B7
;	OUT	(#F5),A
;	LD	A,#10
;	OUT	(#F7),A
	PUSH	IX		;count partitons with shifts <#FFFF
	POP	HL
	LD	BC,#1000
aoi3	LD	A,(HL)		;test for #FFFF
	INC	HL
	AND	(HL)
	INC	HL
	CP	#FF		;resets Cy only when #FF was
	JR	NC,aoi4
	INC	C		;Cy not changed
aoi4	RR	D
	RR	E
	DJNZ	aoi3
	LD	B,C
	RET
aoinic	LD	DE,0
	LD	B,E
	RET

aoinfo	DEC	A		;funkcja 1 - ustawienie przesunicia partycji
	JR	NZ,aoread
	LD	A,C		;w C numer partycji (po 16 na dysk)
	AND	#1F
	ADD	A,A
	LD	C,A
	LD	B,#00
	ADD	IX,BC		;ustalenie przesunicia partycji
	LD	(IX+0),L
	LD	(IX+1),H
;	LD	BC,#C401	;odczyta to z RDSK/PART!
;	LD	DE,#0411	;D-strony, E-sektory
	LD	HL,#0200	;wielko sektora
	RET
aoread	PUSH	AF
	CALL	aoini		;zawsze poprawnie
	POP	BC
;	JP	aocd
aocd	DJNZ	aowrit
aog0	LD	A,#20
	CALL	aowant
aog1	LD	A,#30		;#B0
	OUT	(#F5),A
	IF	revers
	DEC	C
	INI
	INC	C
	INI
	ELSE
	IN	A,(#F6)		;H, odczyt z dysku
	INI			;odczyt z bufora
	LD	(HL),A
	INC	HL
	ENDIF
	LD	A,#37		;#B7
	OUT	(#F5),A
aog2	IN	A,(#F6)
	IN	A,(#F7)
	AND	A
	JP	M,aog2
	BIT	3,A
	JP	NZ,aog1
	AND	#01
	RET
aowrit	DJNZ	aochck
aop0	LD	A,#30
	CALL	aowant
	INC	B
aop1	LD	A,#30		;#B0
	OUT	(#F5),A
	INC	HL
	LD	A,(HL)		;H
	OUT	(#F6),A		;zapis do bufora
	DEC	HL
	OUTI			;L, zapis na dysk
	INC	HL
	LD	A,#37		;#B7
	OUT	(#F5),A
aop2	IN	A,(#F6)
	IN	A,(#F7)
	AND	A
	JP	M,aop2
	BIT	3,A
	JP	NZ,aop1
	AND	#21
	RET

aochck	DJNZ	aoform
aov0	LD	A,#20
	CALL	aowant
aov1	LD	A,#30		;#B0
	OUT	(#F5),A
	INC	HL
	IN	A,(#F6)		;starszy bajt (z dysku)
	SUB	(HL)
	RET	NZ		;jeli le, to A<>0
	DEC	HL
	IN	A,(#F7)		;modszy bajt (z bufora)
	SUB	(HL)
	RET	NZ
	INC	HL
	INC	HL
	LD	A,#37		;#B7
	OUT	(#F5),A
aov2	IN	A,(#F6)
	IN	A,(#F7)
	AND	A
	JP	M,aov2
	BIT	3,A
	JP	NZ,aov1
	AND	#01
	RET

aoform	OR	#FF		;formatowania nie bdzie
	RET

aonext	EQU	$		;wejcie przerwa do nastpnego urzdzenia

;
;	End of file DSKHNDLR.ATOM.GI
;
