;*L+
;DSKHNDLR.ATBUS - dyski IDE w portach #B0..#BF, dostp 16b
;Ostatnia modyfikacja: 03-06-29; (C) Jarek Adamski
;*L-

;	rozmiar dysku odczytywany komend dysku
;020516	zliczanie partycji o przesuniciach <#FFFF
;021122	obsuga partycji jest na wyszym poziomie; tu tylko przesunicia
;000816	dezaktwacja kodu testowego
;000118	zmiana struktury - przy okazji przystosowa do umieszczenia w ROM
;990909	funkcja 1 zwraca informacj, czy dysk istnieje
;980815 zamiana: B-strona, D-cylinder
;970517	funkcja #01 zwraca informacje o partycji
;970422	zmiana z DEVICE na DSKHNDLR, numer funkcji w A; detekcja koca sektora
;970105	procedury wczytuj/zapisuj po 512 B (bya bdna detekcja dla ST351A/X)
;960804 uruchomione automatyczne parkowanie po 4 minutach
;960803 koniec zmian; przetestowany nowy sposb obsugi dysku
;960503 przemyle procedury obsugi tak, eby uruchamiay dysk po #E0
;960403 pocztek przerbki na wybr funkcji rejestrem A
;951010 poprawki pod operacje szesnastobitowe (S = bit 0,B przy INI/OUTI)
;951006 druga partycja od cylindra 124
;950912	kopoty z partycjami - jedna od cylindra 2 (Maxtor 7120A)
;950625 wydzielone z BIOSSAM.GEN, po podczeniu dysku 950619
;
atmins	EQU	30		;ilo minut do automatycznego parkowania

athere	JP	atinte		;wejcie przerwa - co 1s
	JP	atmain
	DEFW	#A002		;numer wersji
	DEFW	atnext-athere,athere,atpart1-atpart,atpart
	DEFM	'DSKHNDLR'
	DEFM	'ATBUS   '
;
;przesunicia w cylindrach poszczeglnych partycji obu dyskw,
;naley je ustawi na pocztku
atpart	DEFW	#0000,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#0000,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
	DEFW	#FFFF,#FFFF,#FFFF,#FFFF
attime	DEFW	60*atmins
atpart1	EQU	$

;procedura obsugujca przerwanie (nie wymagane przechowanie rejestrw AF,HL)
atinte	DEC	(IX+attime-atpart)
	JP	NZ,atnext
	DEC	(IX+attime-atpart+1)
	LD	A,#E0		;komenda >HDPARK<
	CALL	Z,atcom
	JP	atnext		;przekazanie przerwania do nastpnego moduu


;komenda
atcom	PUSH	AF
atcom1	IN	A,(#B7)
	AND	A
	JP	M,atcom1	;zaptlenie do uzyskania gotowoci; JP szybciej
	POP	AF		;w A komenda
	OUT	(#B7),A		;wysanie komendy
atcom2	IN	A,(#B7)
	BIT	7,A
	JP	NZ,atcom2	;zaptlenie do uzyskania gotowoci; JP szybciej
	AND	#25		;maska bdw
	RET

;wybieranie waciwego sektora
atini	PUSH	HL
	LD	HL,60*atmins	;czas do zaparkowania
	LD	(IX+attime-atpart+0),L
	LD	(IX+attime-atpart+1),H
atini1	IN	A,(#B7)
	BIT	7,A
	JR	NZ,atini1
	LD	A,C
	AND	#10		;Master lub Slave
	OR	B		;mamy unit, dodajemy stron
	OR	#A0		;sygnaturka (podobno)
	OUT	(#B6),A		;wybieramy dysk i stron
atini2	IN	A,(#B7)
	BIT	7,A
	JR	NZ,atini2
	LD	A,#01
	OUT	(#B2),A		;ilo sektorw
	LD	A,E
	OUT	(#B3),A		;numer sektora
	LD	A,C		;w C numer partycji (po 16 na dysk)
	AND	#1F
	ADD	A,A
	LD	C,A
	LD	B,#00
	ADD	IX,BC		;pobranie przesunicia partycji
	LD	A,(IX+0)
	ADD	A,D		;cylinder
	OUT	(#B4),A		;LO cieki
	LD	A,(IX+1)
	ADC	A,#00		;dodanie przeniesienia
	OUT	(#B5),A		;HI cieki
	POP	HL
	RET


atwant	LD	B,A		;komenda wymaga gotowoci, przechowana w B
atwan1	IN	A,(#B7)
	RLCA
	JP	C,atwan1	;zaptlenie do uzyskania gotowoci; JP szybciej
	LD	A,B		;w A komenda
	OUT	(#B7),A
	LD	BC,#00B0	;port danych - B jest zmniejszane przed OUTI
atwan2	IN	A,(#B7)
	AND	A
	JP	M,atwan2
	BIT	3,A
	RET	NZ
	AND	#25		;maska bdu
	JR	Z,atwan2	;bez bdu
	POP	AF		;bd
	RET


atmain	AND	#0F
	JR	NZ,atinfo
	COND	dskhnd & #0001
	BIT	4,C		;not for #B0 initiation
	JR	NZ,atinit
;	PUSH	HL		;needed to read IDE identification data
	LD	HL,atpart
	PUSH	IX
	POP	DE
	LD	BC,atpart1-atpart
	LDIR
;	POP	HL
	ENDC
atinit	LD	DE,#0000	;zwraca: B-ilo partycji, DE-maska
	LD	B,E
ati1	DEC	DE
	LD	A,E
	OR	D
	RET	Z
	IN	A,(#B7)
	RLCA
	JR	C,ati1
ati2	LD	A,B
	OUT	(#B4),A
	IN	A,(#B4)
	CP	B
	JR	NZ,atinic
	DJNZ	ati2
	LD	A,#02
	OUT	(#BE),A
;	LD	A,#10
;	OUT	(#B7),A
	PUSH	IX		;count partitons with shifts <#FFFF
	POP	HL
	LD	BC,#1000
ati3	LD	A,(HL)		;test for #FFFF
	INC	HL
	AND	(HL)
	INC	HL
	CP	#FF		;resets Cy only when #FF was
	JR	NC,ati4
	INC	C		;Cy not changed
ati4	RR	D
	RR	E
	DJNZ	ati3
	LD	B,C
	RET
atinic	LD	DE,0
	LD	B,E
	RET

atinfo	DEC	A		;funkcja 1 - ustawienie przesunicia partycji
	JR	NZ,atread
	LD	A,C		;w C numer partycji (po 16 na dysk)
	AND	#1F
	ADD	A,A
	LD	C,A
	LD	B,#00
	ADD	IX,BC		;ustalenie przesunicia partycji
	LD	(IX+0),L
	LD	(IX+1),H
;	LD	BC,#C401	;odczyta to z RDSK/PART!
;	LD	DE,#0411	;D-strony, E-sektory
	LD	HL,#0200	;wielko sektora
	RET
atread	PUSH	AF
	CALL	atini		;zawsze poprawnie
	POP	BC
;	JP	atcd
atcd	DJNZ	atwrit
atg0	LD	A,#20
	CALL	atwant
atg1	INI			;A8=0 - oczyt z dysku
	INI			;A8=1 - odczyt z bufora
atg2	IN	A,(#B7)
	AND	A
	JP	M,atg2
	BIT	3,A
	JP	NZ,atg1
	AND	#01
	RET
atwrit	DJNZ	atchck
atp0	LD	A,#30
	CALL	atwant
	INC	B
atp1	OUTI			;A8=0 - zapis do bufora
	OUTI			;A8=1 - zapis na dysk
atp2	IN	A,(#B7)
	AND	A
	JP	M,atp2
	BIT	3,A
	JP	NZ,atp1
	AND	#21
	RET

atchck	DJNZ	atform
atv0	LD	A,#20
	CALL	atwant
atv1	IN	A,(C)		;A8=0 modszy bajt (z dysku)
	SUB	(HL)
	JR	NZ,atbad	;jeli le, to A<>0
	INC	HL
	DEC	B
	IN	A,(C)		;A8=1 starszy bajt (z bufora)
	SUB	(HL)
	JR	NZ,atbad
	INC	HL
	DEC	B
atv2	IN	A,(#B7)
	AND	A
	JP	M,atv2
	BIT	3,A
	JP	NZ,atv1
	AND	#01
	RET

atbad	RET
	COND	0
	PUSH	AF
	PUSH	HL
	ADD	A,(HL)
	CALL	outhex
	POP	HL
	PUSH	HL
	LD	A,(HL)
	CALL	outhex
	POP	HL
	PUSH	HL
	LD	A,H
	CALL	outhex
	POP	HL
	LD	A,L
	CALL	outhex
	LD	C,#09
	CALL	co80
	POP	AF
	RET
outhex	PUSH	AF
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	outone
	POP	AF
outone	AND	#0F
	OR	#30
	CP	#3A
	JR	C,outh1
	ADD	A,#07
outh1	LD	C,A
	JP	co80
	ENDC

atform	OR	#FF		;formatowania nie bdzie
	RET

atnext	EQU	$		;wejcie przerwa do nastpnego urzdzenia

;
;	End of file DSKHNDLR.ATBUS.GI
;
